/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model.values;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLValue;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.values.CCSLBooleanVariable;
import fr.inria.aoste.trace.AssertionState;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.State;
import fr.inria.aoste.trace.TracePackage;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class CCSLAssertValue
extends CCSLValue {
    private LogicalStep stValue;

    public CCSLAssertValue(ICCSLDebugTarget target, LogicalStep value) {
        super(target, "assert");
        this.stValue = value;
    }

    public void setValue(LogicalStep st) {
        this.stValue = st;
    }

    public String getValueString() throws DebugException {
        if (this.stValue == null) {
            return "null";
        }
        return " LogicalStep  " + this.stValue.getStepNumber();
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        try {
            ICCSLDebugTarget ccsldt = this.getDebugTarget();
            if (this.stValue == null) {
                return new IVariable[0];
            }
            if (!this.stValue.eIsSet((EStructuralFeature)TracePackage.eINSTANCE.getLogicalStep_AssertionStates())) {
                return new IVariable[0];
            }
            int n = this.stValue.getAssertionStates().size();
            IVariable[] vt = new IVariable[n];
            int i = 0;
            while (i < n) {
                AssertionState cs = (AssertionState)this.stValue.getAssertionStates().get(i);
                vt[i] = new CCSLBooleanVariable(ccsldt, this.getClockName((State)cs));
                vt[i].setValue("" + cs.isIsViolated());
                ++i;
            }
            return vt;
        }
        catch (Throwable e) {
            return new IVariable[0];
        }
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.stValue != null;
    }
}

