/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.model.TimeModel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventKind implements Enumerator
{
    UNDEFINED(0, "undefined", "undefined"),
    START(1, "start", "start"),
    FINISH(2, "finish", "finish"),
    SEND(3, "send", "send"),
    RECEIVE(4, "receive", "receive"),
    CONSUME(6, "consume", "consume"),
    PRODUCE(5, "produce", "produce");

    public static final int UNDEFINED_VALUE = 0;
    public static final int START_VALUE = 1;
    public static final int FINISH_VALUE = 2;
    public static final int SEND_VALUE = 3;
    public static final int RECEIVE_VALUE = 4;
    public static final int CONSUME_VALUE = 6;
    public static final int PRODUCE_VALUE = 5;
    private static final EventKind[] VALUES_ARRAY;
    public static final List<EventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventKind[]{UNDEFINED, START, FINISH, SEND, RECEIVE, CONSUME, PRODUCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return START;
            }
            case 2: {
                return FINISH;
            }
            case 3: {
                return SEND;
            }
            case 4: {
                return RECEIVE;
            }
            case 6: {
                return CONSUME;
            }
            case 5: {
                return PRODUCE;
            }
        }
        return null;
    }

    private EventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

