/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPluginContribution;

public class WizardElement
extends NamedElement
implements IPluginContribution {
    String id;
    String className;
    public static final String ATT_NAME = "name";
    public static final String TAG_DESCRIPTION = "description";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String ATT_TEMPLATE = "template";
    public static final String ATT_POINT = "point";
    public static final String ATT_CATEGORY = "category";
    public static final String ATT_TARGETPLUGINID = "targetPluginId";
    private String description;
    protected IConfigurationElement configurationElement;
    private IConfigurationElement template;

    public WizardElement(IConfigurationElement config) {
        super(config.getAttribute(ATT_NAME));
        this.id = config.getAttribute(ATT_ID);
        this.className = config.getAttribute(ATT_CLASS);
        this.configurationElement = config;
    }

    public Object createExecutableExtension() throws CoreException {
        return this.configurationElement.createExecutableExtension(ATT_CLASS);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDescription() {
        IConfigurationElement[] children;
        if (this.description == null && (children = this.configurationElement.getChildren(TAG_DESCRIPTION)).length > 0) {
            this.description = children[0].getValue();
        }
        return this.description;
    }

    public WizardElement(String name, String id, String className, String description) {
        super(name);
        this.id = id;
        this.className = className;
        this.description = description;
    }

    public String getID() {
        return this.id;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getTemplateId() {
        return this.configurationElement.getAttribute(ATT_TEMPLATE);
    }

    public boolean isTemplate() {
        return this.getTemplateId() != null;
    }

    public IConfigurationElement getTemplateElement() {
        if (this.template == null) {
            this.template = this.findTemplateElement();
        }
        return this.template;
    }

    private IConfigurationElement findTemplateElement() {
        String templateId = this.getTemplateId();
        if (templateId == null) {
            return null;
        }
        IConfigurationElement[] templates = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.inria.diverse.commons.eclipse.pde.templates");
        int i = 0;
        while (i < templates.length) {
            IConfigurationElement template = templates[i];
            String id = template.getAttribute(ATT_ID);
            if (id != null && id.equals(templateId)) {
                return template;
            }
            ++i;
        }
        return null;
    }

    public String getContributingId() {
        IConfigurationElement tel = this.getTemplateElement();
        return tel == null ? null : tel.getAttribute("contributingId");
    }

    public String getLocalId() {
        return this.getID();
    }

    public String getPluginId() {
        return null;
    }

    public static WizardElement create(IConfigurationElement config) {
        String name = config.getAttribute(ATT_NAME);
        String id = config.getAttribute(ATT_ID);
        String className = config.getAttribute(ATT_CLASS);
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute(ATT_ICON);
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }
}

