/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DiagnosticLogger;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.ExpressionEvaluationEngine;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.MethodEvaluator;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.EvalEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AntlrAstToAleBehaviorsFactory;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ConvertType;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;

public class EvalBodyService
extends AbstractService {
    private EvalEnvironment evalEnv;
    private Method implem;
    private DiagnosticLogger logger;
    int priority = 101;
    private IAleEnvironment environment;

    public EvalBodyService(IAleEnvironment environment, Method implem, EvalEnvironment evalEnv, DiagnosticLogger logger) {
        this.environment = environment;
        this.implem = implem;
        this.evalEnv = evalEnv;
        this.logger = logger;
    }

    public Object internalInvoke(Object[] arguments) throws Exception {
        EObject caller = (EObject)arguments[0];
        MethodEvaluator evaluator = new MethodEvaluator(this.environment, new ExpressionEvaluationEngine(this.evalEnv.getQueryEnvironment(), this.evalEnv.getListeners()), this.evalEnv.getFeatureAccess());
        ArrayList<Object> args = new ArrayList<Object>();
        int i = 1;
        while (i < arguments.length) {
            args.add(arguments[i]);
            ++i;
        }
        EvaluationResult eval = evaluator.eval(caller, this.implem, args);
        this.logger.notify(eval.getDiagnostic());
        return eval.getResult();
    }

    public String getName() {
        if (this.implem instanceof Method && this.implem.getOperationRef() != null) {
            return this.implem.getOperationRef().getName();
        }
        return "undefined";
    }

    public int getNumberOfParameters() {
        if (this.implem instanceof Method && this.implem.getOperationRef() != null) {
            return this.implem.getOperationRef().getEParameters().size() + 1;
        }
        return 1;
    }

    public List<IType> getParameterTypes(IReadOnlyQueryEnvironment queryEnvironment) {
        ArrayList<IType> result = new ArrayList<IType>();
        ConvertType convert = new ConvertType(queryEnvironment);
        if (this.implem.eContainer() instanceof ExtendedClass) {
            EClass containingClass = ((ExtendedClass)this.implem.eContainer()).getBaseClass();
            result.add((IType)new EClassifierType(queryEnvironment, (EClassifier)containingClass));
        } else if (this.implem.eContainer() instanceof RuntimeClass) {
            RuntimeClass container = (RuntimeClass)this.implem.eContainer();
            String pkgName = ((ModelUnit)container.eContainer()).getName();
            String simpleName = container.getName();
            String fullName = String.valueOf(pkgName) + "." + simpleName;
            Collection candidates = queryEnvironment.getEPackageProvider().getTypes(simpleName);
            Optional<EClassifier> containingClass = candidates.stream().filter(cls -> AntlrAstToAleBehaviorsFactory.getQualifiedName(cls).equals(fullName)).findFirst();
            if (containingClass.isPresent()) {
                result.add((IType)new EClassifierType(queryEnvironment, containingClass.get()));
            }
        }
        if (this.implem.getOperationRef() != null) {
            for (EParameter parameter : this.implem.getOperationRef().getEParameters()) {
                IType aqlParameterType = convert.toAQL((ETypedElement)parameter);
                result.add(aqlParameterType);
            }
        }
        return result;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getShortSignature() {
        List<IType> parameterTypes = this.getParameterTypes((IReadOnlyQueryEnvironment)this.evalEnv.getQueryEnvironment());
        return this.serviceShortSignature(parameterTypes.toArray());
    }

    public String getLongSignature() {
        if (this.implem.eContainer() instanceof RuntimeClass) {
            return String.valueOf(((RuntimeClass)this.implem.eContainer()).getName()) + " " + this.getShortSignature();
        }
        EClass eContainingClass = ((ExtendedClass)this.implem.eContainer()).getBaseClass();
        String ePkgNsURI = null;
        String eClassName = null;
        if (eContainingClass != null) {
            eClassName = eContainingClass.getName();
            EPackage ePackage = eContainingClass.getEPackage();
            ePkgNsURI = ePackage == null ? null : ePackage.getNsURI();
        }
        return String.valueOf(ePkgNsURI) + " " + eClassName + " " + this.getShortSignature();
    }

    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        if (this.implem.getOperationRef() == null) {
            return Collections.emptySet();
        }
        EOperation eOperation = this.implem.getOperationRef();
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        EClassifierType eClassifierType = new EClassifierType(queryEnvironment, eOperation.getEType());
        if (eOperation.isMany()) {
            result.add((IType)new SequenceType(queryEnvironment, (IType)eClassifierType));
        } else if (eClassifierType.getType() != null) {
            result.add((IType)eClassifierType);
        }
        return result;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
    }

    @Deprecated
    public boolean isLowerParameterTypes(IReadOnlyQueryEnvironment queryEnvironment, IService service) {
        List<IType> paramTypes1 = this.getParameterTypes(queryEnvironment);
        List paramTypes2 = service.getParameterTypes(queryEnvironment);
        boolean result = paramTypes1.size() == paramTypes2.size();
        Iterator<IType> it1 = paramTypes1.iterator();
        Iterator it2 = paramTypes2.iterator();
        while (result && it1.hasNext()) {
            IType paramType1 = it1.next();
            IType paramType2 = (IType)it2.next();
            if (!paramType2.equals(paramType1) && paramType2.isAssignableFrom(paramType1)) continue;
            result = false;
        }
        return result;
    }

    public Method getImplem() {
        return this.implem;
    }
}

