/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.ui.common.base.dialogs.AbstractPropertyDialog;
import org.eclipse.etrice.ui.common.base.dialogs.MultiValidator2;
import org.eclipse.etrice.ui.structure.Activator;
import org.eclipse.etrice.ui.structure.dialogs.PortPropertyDialog;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class ActorContainerRefPropertyDialog
extends AbstractPropertyDialog {
    private ActorContainerRef ref;
    private IScope scope;
    private StructureClass sc;
    private boolean newRef;

    public ActorContainerRefPropertyDialog(Shell shell, ActorContainerRef ref, IScope scope, StructureClass sc, boolean newRef) {
        super(shell, "Edit Reference");
        this.ref = ref;
        this.scope = scope;
        this.sc = sc;
        this.newRef = newRef;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point size = this.getShell().getSize();
        this.getShell().setSize((int)((double)size.x * 1.2), size.y);
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        NameValidator nv = new NameValidator();
        ProtocolValidator pv = new ProtocolValidator();
        boolean refIsActor = this.sc instanceof ActorContainerClass;
        boolean containerIsActor = this.sc instanceof ActorClass;
        ArrayList<IEObjectDescription> actors = new ArrayList<IEObjectDescription>();
        for (IEObjectDescription desc : this.scope.getAllElements()) {
            EObject obj = desc.getEObjectOrProxy();
            if (refIsActor && obj instanceof ActorClass) {
                if (containerIsActor) {
                    if (SupportUtil.getInstance().getRoomHelpers().isReferencing((ActorClass)obj, (ActorClass)this.sc)) continue;
                    actors.add(desc);
                    continue;
                }
                actors.add(desc);
                continue;
            }
            if (refIsActor || !(obj instanceof SubSystemClass) || obj == this.sc) continue;
            actors.add(desc);
        }
        Text name = this.createText(body, "&Name:", (EObject)this.ref, RoomPackage.eINSTANCE.getActorContainerRef_Name(), nv);
        Combo refClass = refIsActor ? this.createComboUsingDesc(body, "Actor &Class:", (EObject)this.ref, ActorClass.class, RoomPackage.eINSTANCE.getActorRef_Type(), actors, pv) : this.createComboUsingDesc(body, "SubSystem &Class:", (EObject)this.ref, SubSystemClass.class, RoomPackage.eINSTANCE.getSubSystemRef_Type(), actors, pv);
        this.createDecorator((Control)name, "invalid name");
        this.createDecorator((Control)refClass, "no class selected");
        if (!this.newRef) {
            refClass.setEnabled(false);
            this.createInfoDecorator((Control)refClass, "class fixed for exisiting ref");
        }
        if (this.ref instanceof ActorRef) {
            PortPropertyDialog.Multiplicity2StringConverter m2s = new PortPropertyDialog.Multiplicity2StringConverter();
            PortPropertyDialog.String2MultiplicityConverter s2m = new PortPropertyDialog.String2MultiplicityConverter();
            SizeAndRefTypeValidator multiValidator = new SizeAndRefTypeValidator(bindingContext);
            SizeValidator sizeValidator = new SizeValidator();
            Text size = this.createText(body, "&Multiplicity", (EObject)this.ref, (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_Multiplicity(), sizeValidator, multiValidator, (IConverter)s2m, (IConverter)m2s, false);
            if (this.hasInterfacePortWithMultiplicityAny(((ActorRef)this.ref).getType())) {
                size.setEnabled(false);
                this.createInfoDecorator((Control)size, "size fixed since actor has interface ports with multiplicity *");
            } else {
                this.createDecorator((Control)size, "multiplicity");
            }
            Combo refType = this.createCombo(body, "Reference &Type:", (EObject)this.ref, ReferenceType.class, RoomPackage.eINSTANCE.getActorRef_RefType(), ReferenceType.VALUES, null, multiValidator);
            this.createDecorator((Control)refType, "invalid ref type");
        }
        name.selectAll();
        name.setFocus();
    }

    private boolean hasInterfacePortWithMultiplicityAny(ActorClass ac) {
        if (ac == null) {
            return false;
        }
        for (Port p : ac.getInterfacePorts()) {
            if (p.getMultiplicity() >= 0) continue;
            return true;
        }
        return false;
    }

    protected Image getImage() {
        return Activator.getImage("icons/Structure.gif");
    }

    protected String getFeatureContextHelpId() {
        return "ActorRefPropertyDialog";
    }

    class NameValidator
    implements IValidator {
        NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                if (name.isEmpty()) {
                    return ValidationStatus.error((String)"name must not be empty");
                }
                if (ActorContainerRefPropertyDialog.this.sc instanceof ActorClass) {
                    if (this.nameExists((ActorClass)ActorContainerRefPropertyDialog.this.sc, name)) {
                        return ValidationStatus.error((String)"name already exists");
                    }
                } else if (ActorContainerRefPropertyDialog.this.sc instanceof SubSystemClass) {
                    SubSystemClass ssc = (SubSystemClass)ActorContainerRefPropertyDialog.this.sc;
                    for (ActorRef ar : ssc.getActorRefs()) {
                        if (ar == ActorContainerRefPropertyDialog.this.ref || !ar.getName().equals(name)) continue;
                        return ValidationStatus.error((String)"name already exists");
                    }
                } else if (ActorContainerRefPropertyDialog.this.sc instanceof LogicalSystem) {
                    LogicalSystem ssc = (LogicalSystem)ActorContainerRefPropertyDialog.this.sc;
                    for (SubSystemRef ssr : ssc.getSubSystems()) {
                        if (ssr == ActorContainerRefPropertyDialog.this.ref || !ssr.getName().equals(name)) continue;
                        return ValidationStatus.error((String)"name already exists");
                    }
                } else assert (false) : "unexpected type";
                return Status.OK_STATUS;
            }
            return Status.OK_STATUS;
        }

        private boolean nameExists(ActorClass ac, String name) {
            for (ActorRef ar : ac.getActorRefs()) {
                if (ar == ActorContainerRefPropertyDialog.this.ref || !ar.getName().equals(name)) continue;
                return true;
            }
            if (ac.getActorBase() != null) {
                return this.nameExists(ac.getActorBase(), name);
            }
            return false;
        }
    }

    class ProtocolValidator
    implements IValidator {
        ProtocolValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationStatus.error((String)"select a class");
            }
            return Status.OK_STATUS;
        }
    }

    class SizeAndRefTypeValidator
    extends MultiValidator2 {
        public SizeAndRefTypeValidator(DataBindingContext bindingContext) {
            super(bindingContext, 2);
        }

        public IStatus validate(List<Object> values) {
            int m = (Integer)values.get(0);
            ReferenceType rt = (ReferenceType)values.get(1);
            if (m == 0) {
                return ValidationStatus.error((String)"multiplicity must not be 0");
            }
            if (m < -1) {
                return ValidationStatus.error((String)"multiplicity must be -1 or positive");
            }
            if (rt == ReferenceType.OPTIONAL) {
                if (m > 1) {
                    return ValidationStatus.error((String)"multiplicity >1 not allowed (only fixed actors)");
                }
            } else if (m == -1) {
                return ValidationStatus.error((String)"multiplicity * not allowed (only optional actors)");
            }
            return ValidationStatus.ok();
        }
    }

    class SizeValidator
    implements IValidator {
        SizeValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof Integer) {
                int m = (Integer)value;
                if (m == 0) {
                    return ValidationStatus.error((String)"multiplicity must not be 0");
                }
                if (m < -1) {
                    return ValidationStatus.error((String)"multiplicity must be -1 or positive");
                }
            }
            return ValidationStatus.ok();
        }
    }
}

