/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.provider;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMDiagramTypeProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSupportUtil;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class BaseDiagramProvider {
    private final Multimap<EObject, PictogramElement> baseDiagramBusinessObjs = ArrayListMultimap.create();
    private final FSMHelpers fsmHelpers = FSMSupportUtil.getInstance().getFSMHelpers();

    public BaseDiagramProvider(AbstractFSMDiagramTypeProvider diagramTypeProvider) {
        final DiagramAccessBase diagramAccess = (DiagramAccessBase)diagramTypeProvider.getInjector().getInstance(DiagramAccessBase.class);
        EObject eObject = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagramTypeProvider.getDiagram());
        final ModelComponent mc = (ModelComponent)eObject;
        final ResourceSet rs = diagramTypeProvider.getDiagram().eResource().getResourceSet();
        ArrayList arrayList = CollectionLiterals.newArrayList();
        Procedures.Procedure1<ArrayList<ModelComponent>> procedure1 = new Procedures.Procedure1<ArrayList<ModelComponent>>(){

            public void apply(ArrayList<ModelComponent> it) {
                ModelComponent base = mc.getBase();
                while (base != null && it.add(base)) {
                    base = base.getBase();
                }
            }
        };
        ArrayList baseClasses = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList, (Procedures.Procedure1)procedure1);
        Consumer<ModelComponent> consumer = new Consumer<ModelComponent>(){

            @Override
            public void accept(ModelComponent base) {
                Diagram baseDiagram = diagramAccess.getDiagram((EObject)base, rs);
                if (baseDiagram != null) {
                    BiConsumer<EObject, Collection<EStructuralFeature.Setting>> biConsumer = new BiConsumer<EObject, Collection<EStructuralFeature.Setting>>(){

                        @Override
                        public void accept(final EObject targetEObj, Collection<EStructuralFeature.Setting> eFeatureSetting) {
                            Functions.Function1<EStructuralFeature.Setting, EObject> function1 = new Functions.Function1<EStructuralFeature.Setting, EObject>(){

                                public EObject apply(EStructuralFeature.Setting it) {
                                    return it.getEObject();
                                }
                            };
                            Functions.Function1<PictogramLink, PictogramElement> function12 = new Functions.Function1<PictogramLink, PictogramElement>(){

                                public PictogramElement apply(PictogramLink it) {
                                    return it.getPictogramElement();
                                }
                            };
                            Consumer<PictogramElement> consumer = new Consumer<PictogramElement>(){

                                @Override
                                public void accept(PictogramElement pe) {
                                    BaseDiagramProvider.this.put(mc, targetEObj, pe);
                                }
                            };
                            IterableExtensions.map((Iterable)Iterables.filter((Iterable)IterableExtensions.map(eFeatureSetting, (Functions.Function1)function1), PictogramLink.class), (Functions.Function1)function12).forEach(consumer);
                        }
                    };
                    EcoreUtil.ExternalCrossReferencer.find((EObject)baseDiagram).forEach(biConsumer);
                    rs.getResources().remove((Object)baseDiagram.eResource());
                }
            }
        };
        ListExtensions.reverseView((List)baseClasses).forEach(consumer);
    }

    private boolean put(ModelComponent mc, EObject obj, PictogramElement value) {
        boolean bl;
        boolean bl2 = false;
        if (obj instanceof StateGraph && (bl = this.fsmHelpers.isTopLevel((StateGraph)obj))) {
            this.baseDiagramBusinessObjs.put((Object)mc.getStateMachine(), (Object)value);
        }
        bl2 = this.baseDiagramBusinessObjs.put((Object)obj, (Object)value);
        return bl2;
    }

    public Collection<PictogramElement> getPictograms(EObject roomObj) {
        Collection collection = null;
        collection = roomObj == null ? CollectionLiterals.emptyList() : this.baseDiagramBusinessObjs.get((Object)roomObj);
        return collection;
    }
}

