/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class TypeIntBoundsCheck
extends CifCheck {
    private final boolean checkRangeless;
    private final int minLower;
    private final int maxLower;
    private final int minUpper;
    private final int maxUpper;
    private boolean ignoreAnnotations;

    public TypeIntBoundsCheck(boolean checkRangeless, Integer minLowerBound, Integer maxLowerBound, Integer minUpperBound, Integer maxUpperBound) {
        this.checkRangeless = checkRangeless;
        this.minLower = minLowerBound == null ? Integer.MIN_VALUE : minLowerBound;
        this.maxLower = maxLowerBound == null ? Integer.MAX_VALUE : maxLowerBound;
        this.minUpper = minUpperBound == null ? Integer.MIN_VALUE : minUpperBound;
        this.maxUpper = maxUpperBound == null ? Integer.MAX_VALUE : maxUpperBound;
    }

    public TypeIntBoundsCheck ignoreAnnotations() {
        return this.ignoreAnnotations(true);
    }

    public TypeIntBoundsCheck ignoreAnnotations(boolean ignore) {
        this.ignoreAnnotations = ignore;
        return this;
    }

    protected void preprocessIntType(IntType intType, CifCheckViolations violations) {
        int upper;
        if (!this.checkRangeless && CifTypeUtils.isRangeless((IntType)intType)) {
            return;
        }
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)intType)) {
            return;
        }
        int lower = CifTypeUtils.getLowerBound((IntType)intType);
        if (lower < this.minLower) {
            violations.add((PositionObject)intType, "Integer type lower bound is less than %d", this.minLower);
        }
        if (lower > this.maxLower) {
            violations.add((PositionObject)intType, "Integer type lower bound is greater than %d", this.maxLower);
        }
        if ((upper = CifTypeUtils.getUpperBound((IntType)intType)) < this.minUpper) {
            violations.add((PositionObject)intType, "Integer type upper bound is less than %d", this.minUpper);
        }
        if (upper > this.maxUpper) {
            violations.add((PositionObject)intType, "Integer type upper bound is greater than %d", this.maxUpper);
        }
    }
}

