/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutOnlyWithCertainNumberOfInitLocsCheck
extends CifCheck {
    private final AllowedNumberOfInitLocs allowed;
    private int initLocCount;

    public AutOnlyWithCertainNumberOfInitLocsCheck(AllowedNumberOfInitLocs allowed) {
        this.allowed = allowed;
    }

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        this.initLocCount = 0;
    }

    protected void postprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        if (this.initLocCount == 0 && this.allowed != AllowedNumberOfInitLocs.AT_MOST_ONE) {
            violations.add((PositionObject)aut, "Automaton has no initial location", new Object[0]);
        } else if (this.initLocCount > 1 && this.allowed != AllowedNumberOfInitLocs.AT_LEAST_ONE) {
            violations.add((PositionObject)aut, "Automaton has multiple initial locations", new Object[0]);
        }
    }

    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        EObject parent = loc.eContainer();
        if (parent instanceof LocationParameter) {
            return;
        }
        boolean initial = !loc.getInitials().isEmpty();
        for (Expression initPred : loc.getInitials()) {
            String errMsg = null;
            Expression errExpr = initPred;
            try {
                initial &= CifEvalUtils.evalPred((Expression)initPred, (boolean)true, (boolean)true);
            }
            catch (UnsupportedException e) {
                errMsg = "as one of its initialization predicates cannot be statically evaluated";
            }
            catch (CifEvalException e) {
                if (e.expr != null) {
                    errExpr = e.expr;
                }
                errMsg = "as evaluating one of its initialization predicates results in an evaluation error";
            }
            if (errMsg == null) continue;
            violations.add((PositionObject)errExpr, "Failed to determine whether a location is an initial location, " + errMsg, new Object[0]);
            this.initLocCount = -1;
        }
        if (initial && this.initLocCount != -1) {
            ++this.initLocCount;
        }
    }

    public static enum AllowedNumberOfInitLocs {
        AT_MOST_ONE,
        EXACTLY_ONE,
        AT_LEAST_ONE;

    }
}

