/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.tooldef.runtime.ToolDefEntrySet;
import org.eclipse.escet.tooldef.runtime.ToolDefEqWrap;
import org.eclipse.escet.tooldef.runtime.ToolDefList;
import org.eclipse.escet.tooldef.runtime.ToolDefSet;

public class ToolDefMap<K, V>
implements Map<K, V> {
    private final Map<ToolDefEqWrap<K>, ToolDefEqWrap<V>> storage;

    public ToolDefMap() {
        this.storage = Maps.map();
    }

    public ToolDefMap(int initialCapacity) {
        this.storage = Maps.mapc((int)initialCapacity);
    }

    public ToolDefMap(Map<? extends K, ? extends V> map) {
        this.storage = Maps.mapc((int)map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ToolDefEqWrap<K> key = ToolDefEqWrap.wrap(entry.getKey());
            ToolDefEqWrap<V> value = ToolDefEqWrap.wrap(entry.getValue());
            this.storage.put(key, value);
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        ToolDefEqWrap<Object> wrappedKey = ToolDefEqWrap.wrap(key);
        return this.storage.containsKey(wrappedKey);
    }

    @Override
    public boolean containsValue(Object value) {
        ToolDefEqWrap<Object> wrappedValue = ToolDefEqWrap.wrap(value);
        return this.storage.containsValue(wrappedValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ToolDefEntrySet<K, V>(this.storage.entrySet());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolDefMap)) {
            return false;
        }
        ToolDefMap other = (ToolDefMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (Map.Entry<ToolDefEqWrap<K>, ToolDefEqWrap<V>> entry : this.storage.entrySet()) {
            ToolDefEqWrap<V> otherValue;
            ToolDefEqWrap<K> key = entry.getKey();
            ToolDefEqWrap<V> value = entry.getValue();
            if (value.equals(otherValue = other.storage.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(Object key) {
        ToolDefEqWrap<Object> wrappedKey = ToolDefEqWrap.wrap(key);
        ToolDefEqWrap<V> rslt = this.storage.get(wrappedKey);
        return rslt == null ? null : (V)rslt.value;
    }

    @Override
    public int hashCode() {
        int rslt = ToolDefMap.class.hashCode();
        Iterator<Map.Entry<ToolDefEqWrap<K>, ToolDefEqWrap<V>>> iter = this.storage.entrySet().iterator();
        while (iter.hasNext()) {
            rslt += iter.next().hashCode();
        }
        return rslt;
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return ToolDefSet.wrap(this.storage.keySet());
    }

    @Override
    public V put(K key, V value) {
        ToolDefEqWrap<V> wrappedValue;
        ToolDefEqWrap<K> wrappedKey = ToolDefEqWrap.wrap(key);
        ToolDefEqWrap<V> rslt = this.storage.put(wrappedKey, wrappedValue = ToolDefEqWrap.wrap(value));
        return rslt == null ? null : (V)rslt.value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        ToolDefEqWrap<Object> wrappedKey = ToolDefEqWrap.wrap(key);
        ToolDefEqWrap<V> rslt = this.storage.remove(wrappedKey);
        return rslt == null ? null : (V)rslt.value;
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        txt.append("{");
        for (Map.Entry<ToolDefEqWrap<K>, ToolDefEqWrap<V>> entry : this.storage.entrySet()) {
            if (txt.length() > 1) {
                txt.append(", ");
            }
            txt.append(entry.getKey().toString());
            txt.append(": ");
            txt.append(entry.getValue().toString());
        }
        txt.append("}");
        return txt.toString();
    }

    @Override
    public Collection<V> values() {
        ToolDefList rslt = new ToolDefList(this.storage.size());
        for (ToolDefEqWrap<V> wrap : this.storage.values()) {
            rslt.add(wrap.value);
        }
        return rslt;
    }
}

