/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.osgi.framework.Version;

public class Util {
    private static final String GTK_VERSION_PROPERTY = "org.eclipse.swt.internal.gtk.version";
    private static Boolean isGtk3;

    public static Image scaleImage(Image image, int maxWidth, int maxHeight) {
        return Util.scaleImage(image, maxWidth, maxHeight, null);
    }

    public static Image scaleImage(Image image, int maxWidth, int maxHeight, Color background) {
        int newHeight;
        int newWidth;
        Rectangle bounds = image.getBounds();
        float widthRatio = (float)bounds.width / (float)maxWidth;
        float heightRatio = (float)bounds.height / (float)maxHeight;
        if (widthRatio > heightRatio) {
            newWidth = maxWidth;
            newHeight = -1;
        } else {
            newWidth = -1;
            newHeight = maxHeight;
        }
        if (newHeight == -1) {
            newHeight = Math.min(maxHeight, (int)((float)bounds.height / widthRatio));
        } else {
            newWidth = Math.min(maxWidth, (int)((float)bounds.width / heightRatio));
        }
        Image scaledImage = new Image(image.getDevice(), newWidth, newHeight);
        GC gc = new GC((Drawable)scaledImage);
        try {
            gc.setAntialias(1);
            gc.setInterpolation(2);
            if (background != null) {
                gc.setBackground(background);
                gc.fillRectangle(0, 0, newWidth, newHeight);
            }
            gc.drawImage(image, 0, 0, bounds.width, bounds.height, 0, 0, newWidth, newHeight);
        }
        finally {
            gc.dispose();
        }
        return scaledImage;
    }

    public static int computeMessageType(IStatus status) {
        int messageType;
        switch (status.getSeverity()) {
            case 0: 
            case 1: {
                messageType = 1;
                break;
            }
            case 2: {
                messageType = 2;
                break;
            }
            default: {
                messageType = 3;
            }
        }
        return messageType;
    }

    public static boolean isGtk3() {
        if (isGtk3 == null) {
            Version gtkVersion;
            String gtkVersionStr;
            isGtk3 = "gtk".equals(Platform.getWS()) ? ((gtkVersionStr = System.getProperty(GTK_VERSION_PROPERTY)) != null ? Boolean.valueOf((gtkVersion = new Version(gtkVersionStr)).getMajor() >= 3) : Boolean.valueOf(false)) : Boolean.valueOf(false);
        }
        return isGtk3;
    }
}

