/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.ode;

import org.apache.commons.math3.analysis.solvers.BaseSecantSolver;
import org.apache.commons.math3.analysis.solvers.IllinoisSolver;
import org.apache.commons.math3.analysis.solvers.PegasusSolver;
import org.apache.commons.math3.analysis.solvers.RegulaFalsiSolver;

public enum RootFinderAlgo {
    REGULA_FALSI("Regula Falsi (False position) method"),
    ILLINOIS("Illinois method"),
    PEGASUS("Pegasus method");

    public final String name;

    private RootFinderAlgo(String name) {
        this.name = name;
    }

    public BaseSecantSolver create(double atol, double rtol) {
        switch (this) {
            case REGULA_FALSI: {
                return new RegulaFalsiSolver(rtol, atol);
            }
            case ILLINOIS: {
                return new IllinoisSolver(rtol, atol);
            }
            case PEGASUS: {
                return new PegasusSolver(rtol, atol);
            }
        }
        return null;
    }
}

