/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IFindReplaceTargetExtension4;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.internal.findandreplace.FindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.FindReplaceLogicMessageGenerator;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.HistoryStore;
import org.eclipse.ui.internal.findandreplace.IFindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.status.IFindReplaceStatus;
import org.eclipse.ui.internal.texteditor.SWTUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class FindReplaceDialog
extends Dialog {
    private static final int CLOSE_BUTTON_ID = 101;
    private IFindReplaceLogic findReplaceLogic;
    private final FindModifyListener fFindModifyListener = new FindModifyListener();
    private static final int HISTORY_SIZE = 15;
    private HistoryStore findHistory;
    private HistoryStore replaceHistory;
    private Shell fParentShell;
    private Shell fActiveShell;
    private final ActivationListener fActivationListener = new ActivationListener();
    private Label fReplaceLabel;
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fGlobalRadioButton;
    private Button fSelectedRangeRadioButton;
    private Button fCaseCheckBox;
    private Button fWrapCheckBox;
    private Button fWholeWordCheckBox;
    private Button fIncrementalCheckBox;
    private Button fIsRegExCheckBox;
    private Button fReplaceSelectionButton;
    private Button fReplaceFindButton;
    private Button fFindNextButton;
    private Button fReplaceAllButton;
    private Button fSelectAllButton;
    private Combo fFindField;
    private Combo fReplaceField;
    private ContentAssistCommandAdapter fContentAssistFindField;
    private ContentAssistCommandAdapter fContentAssistReplaceField;
    private Rectangle fDialogPositionInit;
    private IDialogSettings fDialogSettings;
    private boolean fGiveFocusToFindField = true;
    private HashMap<Character, Button> fMnemonicButtonMap = new HashMap();

    public FindReplaceDialog(Shell parentShell) {
        super(parentShell);
        this.findReplaceLogic = new FindReplaceLogic();
        this.findReplaceLogic.activate(SearchOptions.GLOBAL);
        this.fParentShell = null;
        this.fDialogPositionInit = null;
        this.setupSearchHistory();
        this.readConfiguration();
        this.setShellStyle(this.getShellStyle() ^ 0x10000);
        this.setBlockOnOpen(false);
    }

    protected boolean isResizable() {
        return true;
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.find_replace_dialog_context");
        this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
        this.updateCombo(this.fFindField, this.findHistory.get());
        this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
        this.updateCombo(this.fReplaceField, this.replaceHistory.get());
        this.initFindString();
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText(FindReplaceMessages.FindReplace_Dialog_Title);
        this.updateButtonState();
    }

    private Composite createButtonSection(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = -2;
        panel.setLayout((Layout)layout);
        this.fFindNextButton = this.makeButton(panel, FindReplaceMessages.FindReplace_FindNextButton_label, 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.setupFindReplaceLogic();
                boolean eventRequiresInverseSearchDirection = (e.stateMask & SWT.MODIFIER_MASK) == 131072;
                boolean forwardSearchActivated = FindReplaceDialog.this.findReplaceLogic.isActive(SearchOptions.FORWARD);
                boolean incrementalSearchActivated = FindReplaceDialog.this.findReplaceLogic.isActive(SearchOptions.INCREMENTAL);
                FindReplaceDialog.this.activateInFindReplaceLogicIf(SearchOptions.FORWARD, eventRequiresInverseSearchDirection ^ forwardSearchActivated);
                FindReplaceDialog.this.findReplaceLogic.deactivate(SearchOptions.INCREMENTAL);
                boolean somethingFound = FindReplaceDialog.this.findReplaceLogic.performSearch(FindReplaceDialog.this.getFindString());
                FindReplaceDialog.this.activateInFindReplaceLogicIf(SearchOptions.INCREMENTAL, incrementalSearchActivated);
                FindReplaceDialog.this.activateInFindReplaceLogicIf(SearchOptions.FORWARD, forwardSearchActivated);
                FindReplaceDialog.this.writeSelection();
                FindReplaceDialog.this.updateButtonState(!somethingFound);
                FindReplaceDialog.this.updateFindHistory();
                FindReplaceDialog.this.evaluateFindReplaceStatus();
            }
        });
        this.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        this.fSelectAllButton = this.makeButton(panel, FindReplaceMessages.FindReplace_SelectAllButton_label, 106, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)(FindReplaceDialog.this.fActiveShell != null ? FindReplaceDialog.this.fActiveShell.getDisplay() : Display.getCurrent()), () -> FindReplaceDialog.this.findReplaceLogic.performSelectAll(FindReplaceDialog.this.getFindString()));
                FindReplaceDialog.this.writeSelection();
                FindReplaceDialog.this.updateButtonState();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.evaluateFindReplaceStatus();
            }
        });
        this.setGridData((Control)this.fSelectAllButton, 4, true, 4, false);
        Label filler = new Label(panel, 0);
        this.fReplaceFindButton = this.makeButton(panel, FindReplaceMessages.FindReplace_ReplaceFindButton_label, 103, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.findReplaceLogic.performReplaceAndFind(FindReplaceDialog.this.getFindString(), FindReplaceDialog.this.getReplaceString())) {
                    FindReplaceDialog.this.writeSelection();
                }
                FindReplaceDialog.this.updateButtonState();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.evaluateFindReplaceStatus();
            }
        });
        this.setGridData((Control)this.fReplaceFindButton, 4, false, 4, false);
        this.fReplaceSelectionButton = this.makeButton(panel, FindReplaceMessages.FindReplace_ReplaceSelectionButton_label, 104, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.findReplaceLogic.performSelectAndReplace(FindReplaceDialog.this.getFindString(), FindReplaceDialog.this.getReplaceString())) {
                    FindReplaceDialog.this.writeSelection();
                }
                FindReplaceDialog.this.updateButtonState();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.evaluateFindReplaceStatus();
            }
        });
        this.setGridData((Control)this.fReplaceSelectionButton, 4, false, 4, false);
        this.fReplaceAllButton = this.makeButton(panel, FindReplaceMessages.FindReplace_ReplaceAllButton_label, 105, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)(FindReplaceDialog.this.fActiveShell != null ? FindReplaceDialog.this.fActiveShell.getDisplay() : Display.getCurrent()), () -> FindReplaceDialog.this.findReplaceLogic.performReplaceAll(FindReplaceDialog.this.getFindString(), FindReplaceDialog.this.getReplaceString()));
                FindReplaceDialog.this.writeSelection();
                FindReplaceDialog.this.updateButtonState();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.evaluateFindReplaceStatus();
            }
        });
        this.setGridData((Control)this.fReplaceAllButton, 4, true, 4, false);
        return panel;
    }

    private Composite createConfigPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite directionGroup = this.createDirectionGroup(panel);
        this.setGridData((Control)directionGroup, 4, true, 4, false);
        Composite scopeGroup = this.createScopeGroup(panel);
        this.setGridData((Control)scopeGroup, 4, true, 4, false);
        Composite optionsGroup = this.createOptionsGroup(panel);
        this.setGridData((Control)optionsGroup, 4, true, 4, true);
        ((GridData)optionsGroup.getLayoutData()).horizontalSpan = 2;
        return panel;
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        this.setGridData((Control)panel, 4, true, 4, true);
        final ScrolledComposite scrolled = new ScrolledComposite(panel, 512);
        this.setGridData((Control)scrolled, 4, true, 4, true);
        final Composite mainArea = new Composite((Composite)scrolled, 0);
        this.setGridData((Control)mainArea, 4, true, 4, true);
        mainArea.setLayout((Layout)new GridLayout(1, true));
        Composite inputPanel = this.createInputPanel(mainArea);
        this.setGridData((Control)inputPanel, 4, true, 128, false);
        Composite configPanel = this.createConfigPanel(mainArea);
        this.setGridData((Control)configPanel, 4, true, 128, true);
        scrolled.setContent((Control)mainArea);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        scrolled.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrolled.setMinHeight(mainArea.computeSize((int)-1, (int)-1).y);
            }
        });
        Composite buttonPanelB = this.createButtonSection(panel);
        this.setGridData((Control)buttonPanelB, 131072, true, 1024, false);
        Composite statusBar = this.createStatusAndCloseButton(panel);
        this.setGridData((Control)statusBar, 4, true, 1024, false);
        panel.addTraverseListener(e -> {
            Character mnemonic;
            if (e.detail == 4) {
                Control controlWithFocus;
                if (!Util.isMac() && (controlWithFocus = this.getShell().getDisplay().getFocusControl()) != null && (controlWithFocus.getStyle() & 8) == 8) {
                    return;
                }
                Event event1 = new Event();
                event1.type = 13;
                event1.stateMask = e.stateMask;
                this.fFindNextButton.notifyListeners(13, event1);
                e.doit = false;
            } else if (e.detail == 128 && this.fMnemonicButtonMap.containsKey(mnemonic = Character.valueOf(Character.toLowerCase(e.character)))) {
                Button button = this.fMnemonicButtonMap.get(mnemonic);
                if ((this.fFindField.isFocusControl() || this.fReplaceField.isFocusControl() || (button.getStyle() & 8) != 0) && button.isEnabled()) {
                    Event event2 = new Event();
                    event2.type = 13;
                    event2.stateMask = e.stateMask;
                    if ((button.getStyle() & 0x10) != 0) {
                        Composite buttonParent = button.getParent();
                        if (buttonParent != null) {
                            Control[] controlArray = buttonParent.getChildren();
                            int n = controlArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control child = controlArray[n2];
                                ((Button)child).setSelection(false);
                                ++n2;
                            }
                        }
                        button.setSelection(true);
                    } else {
                        button.setSelection(!button.getSelection());
                    }
                    button.notifyListeners(13, event2);
                    e.detail = 0;
                    e.doit = true;
                }
            }
        });
        this.updateButtonState();
        FindReplaceDialog.applyDialogFont((Control)panel);
        return panel;
    }

    private void setContentAssistsEnablement(boolean enable) {
        this.fContentAssistFindField.setEnabled(enable);
        this.fContentAssistReplaceField.setEnabled(enable);
    }

    private Composite createDirectionGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(FindReplaceMessages.FindReplace_Direction);
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.activateInFindReplaceLogicIf(SearchOptions.FORWARD, FindReplaceDialog.this.fForwardRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText(FindReplaceMessages.FindReplace_ForwardRadioButton_label);
        this.setGridData((Control)this.fForwardRadioButton, 16384, false, 0x1000000, false);
        this.fForwardRadioButton.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fForwardRadioButton);
        Button backwardRadioButton = new Button((Composite)group, 16400);
        backwardRadioButton.setText(FindReplaceMessages.FindReplace_BackwardRadioButton_label);
        this.setGridData((Control)backwardRadioButton, 16384, false, 0x1000000, false);
        backwardRadioButton.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(backwardRadioButton);
        this.activateInFindReplaceLogicIf(SearchOptions.FORWARD, true);
        backwardRadioButton.setSelection(!this.findReplaceLogic.isActive(SearchOptions.FORWARD));
        this.fForwardRadioButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.FORWARD));
        return panel;
    }

    private Composite createScopeGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(FindReplaceMessages.FindReplace_Scope);
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fGlobalRadioButton = new Button((Composite)group, 16400);
        this.fGlobalRadioButton.setText(FindReplaceMessages.FindReplace_GlobalRadioButton_label);
        this.setGridData((Control)this.fGlobalRadioButton, 16384, false, 0x1000000, false);
        this.fGlobalRadioButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.GLOBAL));
        this.fGlobalRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceDialog.this.fGlobalRadioButton.getSelection() || FindReplaceDialog.this.findReplaceLogic.isActive(SearchOptions.GLOBAL)) {
                    return;
                }
                FindReplaceDialog.this.findReplaceLogic.activate(SearchOptions.GLOBAL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.storeButtonWithMnemonicInMap(this.fGlobalRadioButton);
        this.fSelectedRangeRadioButton = new Button((Composite)group, 16400);
        this.fSelectedRangeRadioButton.setText(FindReplaceMessages.FindReplace_SelectedRangeRadioButton_label);
        this.setGridData((Control)this.fSelectedRangeRadioButton, 16384, false, 0x1000000, false);
        this.fSelectedRangeRadioButton.setSelection(!this.findReplaceLogic.isActive(SearchOptions.GLOBAL));
        this.fSelectedRangeRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceDialog.this.fSelectedRangeRadioButton.getSelection() || !FindReplaceDialog.this.findReplaceLogic.isActive(SearchOptions.GLOBAL)) {
                    return;
                }
                FindReplaceDialog.this.findReplaceLogic.deactivate(SearchOptions.GLOBAL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.storeButtonWithMnemonicInMap(this.fSelectedRangeRadioButton);
        return panel;
    }

    private Composite createInputPanel(Composite parent) {
        ModifyListener listener = e -> this.updateButtonState();
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label findLabel = new Label(panel, 16384);
        findLabel.setText(FindReplaceMessages.FindReplace_Find_label);
        this.setGridData((Control)findLabel, 16384, false, 0x1000000, false);
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fFindField = new Combo(panel, 2052);
        this.fContentAssistFindField = new ContentAssistCommandAdapter((Control)this.fFindField, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.setGridData((Control)this.fFindField, 4, true, 0x1000000, false);
        this.addDecorationMargin((Control)this.fFindField);
        this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
        this.fReplaceLabel = new Label(panel, 16384);
        this.fReplaceLabel.setText(FindReplaceMessages.FindReplace_Replace_label);
        this.setGridData((Control)this.fReplaceLabel, 16384, false, 0x1000000, false);
        FindReplaceDocumentAdapterContentProposalProvider replaceProposer = new FindReplaceDocumentAdapterContentProposalProvider(false);
        this.fReplaceField = new Combo(panel, 2052);
        this.fContentAssistReplaceField = new ContentAssistCommandAdapter((Control)this.fReplaceField, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)replaceProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.setGridData((Control)this.fReplaceField, 4, true, 0x1000000, false);
        this.addDecorationMargin((Control)this.fReplaceField);
        this.fReplaceField.addModifyListener(listener);
        return panel;
    }

    private Composite createOptionsGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 32);
        group.setText(FindReplaceMessages.FindReplace_Options);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.setupFindReplaceLogic();
                FindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fCaseCheckBox = new Button((Composite)group, 16416);
        this.fCaseCheckBox.setText(FindReplaceMessages.FindReplace_CaseCheckBox_label);
        this.setGridData((Control)this.fCaseCheckBox, 16384, false, 0x1000000, false);
        this.fCaseCheckBox.setSelection(this.findReplaceLogic.isActive(SearchOptions.CASE_SENSITIVE));
        this.fCaseCheckBox.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fCaseCheckBox);
        this.fWrapCheckBox = new Button((Composite)group, 16416);
        this.fWrapCheckBox.setText(FindReplaceMessages.FindReplace_WrapCheckBox_label);
        this.setGridData((Control)this.fWrapCheckBox, 16384, false, 0x1000000, false);
        this.fWrapCheckBox.setSelection(this.findReplaceLogic.isActive(SearchOptions.WRAP));
        this.fWrapCheckBox.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fWrapCheckBox);
        this.fWholeWordCheckBox = new Button((Composite)group, 16416);
        this.fWholeWordCheckBox.setText(FindReplaceMessages.FindReplace_WholeWordCheckBox_label);
        this.setGridData((Control)this.fWholeWordCheckBox, 16384, false, 0x1000000, false);
        this.fWholeWordCheckBox.setSelection(this.findReplaceLogic.isActive(SearchOptions.WHOLE_WORD));
        this.fWholeWordCheckBox.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fWholeWordCheckBox);
        this.fIncrementalCheckBox = new Button((Composite)group, 16416);
        this.fIncrementalCheckBox.setText(FindReplaceMessages.FindReplace_IncrementalCheckBox_label);
        this.setGridData((Control)this.fIncrementalCheckBox, 16384, false, 0x1000000, false);
        this.fIncrementalCheckBox.setSelection(this.findReplaceLogic.isActive(SearchOptions.INCREMENTAL));
        this.fIncrementalCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.setupFindReplaceLogic();
                FindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.storeButtonWithMnemonicInMap(this.fIncrementalCheckBox);
        this.fIsRegExCheckBox = new Button((Composite)group, 16416);
        this.fIsRegExCheckBox.setText(FindReplaceMessages.FindReplace_RegExCheckbox_label);
        this.setGridData((Control)this.fIsRegExCheckBox, 16384, false, 0x1000000, false);
        ((GridData)this.fIsRegExCheckBox.getLayoutData()).horizontalSpan = 2;
        this.fIsRegExCheckBox.setSelection(this.findReplaceLogic.isActive(SearchOptions.REGEX));
        this.fIsRegExCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = FindReplaceDialog.this.fIsRegExCheckBox.getSelection();
                FindReplaceDialog.this.setupFindReplaceLogic();
                FindReplaceDialog.this.storeSettings();
                FindReplaceDialog.this.updateButtonState();
                FindReplaceDialog.this.setContentAssistsEnablement(newState);
                FindReplaceDialog.this.fIncrementalCheckBox.setEnabled(FindReplaceDialog.this.findReplaceLogic.isIncrementalSearchAvailable());
            }
        });
        this.storeButtonWithMnemonicInMap(this.fIsRegExCheckBox);
        this.fWholeWordCheckBox.setEnabled(this.findReplaceLogic.isWholeWordSearchAvailable(this.getFindString()));
        this.fWholeWordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.updateButtonState();
            }
        });
        this.fIncrementalCheckBox.setEnabled(this.findReplaceLogic.isIncrementalSearchAvailable());
        return panel;
    }

    private Composite createStatusAndCloseButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        this.fStatusLabel = new Label(panel, 16384);
        this.setGridData((Control)this.fStatusLabel, 4, true, 0x1000000, false);
        String label = FindReplaceMessages.FindReplace_CloseButton_label;
        Button closeButton = this.createButton(panel, 101, label, false);
        this.setGridData((Control)closeButton, 131072, false, 1024, false);
        return panel;
    }

    protected void buttonPressed(int buttonID) {
        if (buttonID == 101) {
            this.close();
        }
    }

    private Rectangle getDialogBoundaries() {
        if (this.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    private String getFindString() {
        if (this.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return "";
    }

    private String getReplaceString() {
        if (this.okToUse((Control)this.fReplaceField)) {
            return this.fReplaceField.getText();
        }
        return "";
    }

    private String getFirstLine(String selection) {
        if (!selection.isEmpty()) {
            int delimiterOffset = TextUtilities.nextDelimiter((CharSequence)selection, (int)0).delimiterIndex;
            if (delimiterOffset > 0) {
                return selection.substring(0, delimiterOffset);
            }
            if (delimiterOffset == -1) {
                return selection;
            }
        }
        return "";
    }

    public boolean close() {
        this.handleDialogClose();
        return super.close();
    }

    private void handleDialogClose() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
        }
        if (this.fParentShell != null) {
            this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            this.fParentShell = null;
        }
        this.getShell().removeShellListener((ShellListener)this.fActivationListener);
        this.storeSettings();
        this.findReplaceLogic.dispose();
        this.fActiveShell = null;
    }

    private void writeSelection() {
        String selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        IDialogSettings s = this.getDialogSettings();
        s.put("selection", selection);
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.writeConfiguration();
    }

    private void initFindString() {
        if (!this.okToUse((Control)this.fFindField)) {
            return;
        }
        this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
        if (this.hasTargetSelection()) {
            this.initFindStringFromSelection();
        } else {
            this.initFindStringFromHistory();
        }
        this.fFindField.setSelection(new Point(0, this.fFindField.getText().length()));
        this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
    }

    private boolean hasTargetSelection() {
        String selection = this.getCurrentSelection();
        return selection != null && !selection.isEmpty();
    }

    private void initFindStringFromSelection() {
        String selection = this.getCurrentSelection();
        String searchInput = this.getFirstLine(selection);
        boolean isSingleLineInput = searchInput.equals(selection);
        if (this.findReplaceLogic.isRegExSearchAvailableAndActive()) {
            searchInput = FindReplaceDocumentAdapter.escapeForRegExPattern((String)selection);
        }
        this.fFindField.setText(searchInput);
        if (isSingleLineInput) {
            this.findReplaceLogic.findAndSelect(this.findReplaceLogic.getTarget().getSelection().x, this.fFindField.getText());
        } else {
            this.fGlobalRadioButton.setSelection(false);
            this.fSelectedRangeRadioButton.setSelection(true);
            this.findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        }
    }

    private void initFindStringFromHistory() {
        if ("".equals(this.fFindField.getText())) {
            if (!this.findHistory.isEmpty()) {
                this.fFindField.setText(this.findHistory.get(0));
            } else {
                this.fFindField.setText("");
            }
        }
    }

    private Button makeButton(Composite parent, String label, int id, boolean dfltButton, SelectionListener listener) {
        Button button = this.createButton(parent, id, label, dfltButton);
        button.addSelectionListener(listener);
        this.storeButtonWithMnemonicInMap(button);
        return button;
    }

    private void storeButtonWithMnemonicInMap(Button button) {
        char mnemonic = LegacyActionTools.extractMnemonic((String)button.getText());
        if (mnemonic != '\u0000') {
            this.fMnemonicButtonMap.put(Character.valueOf(Character.toLowerCase(mnemonic)), button);
        }
    }

    private void setGridData(Control component, int horizontalAlignment, boolean grabExcessHorizontalSpace, int verticalAlignment, boolean grabExcessVerticalSpace) {
        if (component instanceof Button && (component.getStyle() & 8) != 0) {
            SWTUtil.setButtonDimensionHint((Button)component);
            gd = (GridData)component.getLayoutData();
        } else {
            gd = new GridData();
            component.setLayoutData((Object)gd);
            gd.horizontalAlignment = horizontalAlignment;
            gd.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        }
        gd.verticalAlignment = verticalAlignment;
        gd.grabExcessVerticalSpace = grabExcessVerticalSpace;
    }

    private void addDecorationMargin(Control control) {
        Object layoutData = control.getLayoutData();
        if (!(layoutData instanceof GridData)) {
            return;
        }
        GridData gd = (GridData)layoutData;
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        gd.horizontalIndent = dec.getImage().getBounds().width;
    }

    private void updateButtonState() {
        this.updateButtonState(false);
    }

    private void updateButtonState(boolean disableReplace) {
        this.setupFindReplaceLogic();
        if (this.okToUse((Control)this.getShell()) && this.okToUse((Control)this.fFindNextButton)) {
            boolean hasActiveSelection = false;
            String selection = this.getCurrentSelection();
            if (selection != null) {
                hasActiveSelection = !selection.isEmpty();
            }
            boolean enable = this.findReplaceLogic.getTarget() != null && (this.fActiveShell == this.fParentShell || this.fActiveShell == this.getShell());
            IFindReplaceTarget target = this.findReplaceLogic.getTarget();
            String str = this.getFindString();
            boolean isFindStringSet = str != null && !str.isEmpty();
            String selectionString = enable ? target.getSelection().toString() : "";
            boolean isTargetEditable = enable ? target.isEditable() : false;
            boolean isRegExSearchAvailableAndActive = this.findReplaceLogic.isRegExSearchAvailableAndActive();
            boolean isSelectionGoodForReplace = selectionString != "" || !isRegExSearchAvailableAndActive;
            this.fWholeWordCheckBox.setEnabled(this.findReplaceLogic.isWholeWordSearchAvailable(this.getFindString()));
            this.fFindNextButton.setEnabled(enable && isFindStringSet);
            this.fSelectAllButton.setEnabled(enable && isFindStringSet && target instanceof IFindReplaceTargetExtension4);
            this.fReplaceSelectionButton.setEnabled(!disableReplace && enable && isTargetEditable && hasActiveSelection && isSelectionGoodForReplace);
            this.fReplaceFindButton.setEnabled(!disableReplace && enable && isTargetEditable && isFindStringSet && hasActiveSelection && isSelectionGoodForReplace);
            this.fReplaceAllButton.setEnabled(enable && isTargetEditable && isFindStringSet);
        }
    }

    private void updateCombo(Combo combo, Iterable<String> content) {
        combo.removeAll();
        for (String element : content) {
            combo.add(element.toString());
        }
    }

    private void updateFindAndReplaceHistory() {
        this.updateFindHistory();
        if (this.okToUse((Control)this.fReplaceField)) {
            this.updateHistory(this.fReplaceField, this.replaceHistory);
        }
    }

    private void updateFindHistory() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
            if (Util.isLinux()) {
                this.fFindModifyListener.ignoreNextEvent();
            }
            this.updateHistory(this.fFindField, this.findHistory);
            this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
        }
    }

    private void updateHistory(Combo combo, HistoryStore history) {
        String findString = combo.getText();
        history.remove(findString);
        history.add(findString);
        Point selection = combo.getSelection();
        this.updateCombo(combo, history.get());
        combo.setText(findString);
        combo.setSelection(selection);
    }

    public void updateTarget(IFindReplaceTarget target, boolean isTargetEditable, boolean initializeFindString) {
        boolean targetExists;
        this.findReplaceLogic.updateTarget(target, isTargetEditable);
        boolean globalSearch = this.findReplaceLogic.isActive(SearchOptions.GLOBAL);
        this.fGlobalRadioButton.setSelection(globalSearch);
        boolean useSelectedLines = !globalSearch;
        this.fSelectedRangeRadioButton.setSelection(useSelectedLines);
        boolean bl = targetExists = this.findReplaceLogic.getTarget() != null;
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            this.fIsRegExCheckBox.setEnabled(targetExists && this.findReplaceLogic.getTarget() instanceof IFindReplaceTargetExtension3);
        }
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            this.fWholeWordCheckBox.setEnabled(this.findReplaceLogic.isWholeWordSearchAvailable(this.getFindString()));
        }
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            this.fIncrementalCheckBox.setEnabled(this.findReplaceLogic.isIncrementalSearchAvailable());
        }
        if (this.okToUse((Control)this.fReplaceLabel)) {
            this.fReplaceLabel.setEnabled(targetExists && this.findReplaceLogic.getTarget().isEditable());
            this.fReplaceField.setEnabled(targetExists && this.findReplaceLogic.getTarget().isEditable());
            this.fReplaceAllButton.setEnabled(targetExists && this.findReplaceLogic.getTarget().isEditable());
            if (initializeFindString) {
                this.initFindString();
                this.fGiveFocusToFindField = true;
            }
        }
        this.updateButtonState();
        this.setContentAssistsEnablement(this.findReplaceLogic.isRegExSearchAvailableAndActive());
    }

    public void setParentShell(Shell shell) {
        if (shell != this.fParentShell) {
            if (this.fParentShell != null) {
                this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fParentShell = shell;
            this.fParentShell.addShellListener((ShellListener)this.fActivationListener);
        }
        this.fActiveShell = shell;
    }

    private void setupSearchHistory() {
        this.findHistory = new HistoryStore(this.getDialogSettings(), "findhistory", 15);
        this.replaceHistory = new HistoryStore(this.getDialogSettings(), "replacehistory", 15);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FindReplaceDialog.class)).getDialogSettings();
        this.fDialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = ((Object)((Object)this)).getClass().getName() + "_dialogBounds";
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FindReplaceDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.activateInFindReplaceLogicIf(SearchOptions.WRAP, s.get("wrap") == null || s.getBoolean("wrap"));
        this.activateInFindReplaceLogicIf(SearchOptions.CASE_SENSITIVE, s.getBoolean("casesensitive"));
        this.activateInFindReplaceLogicIf(SearchOptions.WHOLE_WORD, s.getBoolean("wholeword"));
        this.activateInFindReplaceLogicIf(SearchOptions.INCREMENTAL, s.getBoolean("incremental"));
        this.activateInFindReplaceLogicIf(SearchOptions.REGEX, s.getBoolean("isRegEx"));
    }

    private void setupFindReplaceLogic() {
        this.activateInFindReplaceLogicIf(SearchOptions.WRAP, this.fWrapCheckBox.getSelection());
        this.activateInFindReplaceLogicIf(SearchOptions.FORWARD, this.fForwardRadioButton.getSelection());
        this.activateInFindReplaceLogicIf(SearchOptions.CASE_SENSITIVE, this.fCaseCheckBox.getSelection());
        this.activateInFindReplaceLogicIf(SearchOptions.REGEX, this.fIsRegExCheckBox.getSelection());
        this.activateInFindReplaceLogicIf(SearchOptions.WHOLE_WORD, this.fWholeWordCheckBox.getSelection());
        this.activateInFindReplaceLogicIf(SearchOptions.INCREMENTAL, this.fIncrementalCheckBox.getSelection());
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put("wrap", this.findReplaceLogic.isActive(SearchOptions.WRAP));
        s.put("casesensitive", this.findReplaceLogic.isActive(SearchOptions.CASE_SENSITIVE));
        s.put("wholeword", this.findReplaceLogic.isActive(SearchOptions.WHOLE_WORD));
        s.put("incremental", this.findReplaceLogic.isActive(SearchOptions.INCREMENTAL));
        s.put("isRegEx", this.findReplaceLogic.isActive(SearchOptions.REGEX));
        String findString = this.getFindString();
        this.findHistory.add(findString);
        String replaceString = this.getReplaceString();
        this.replaceHistory.add(replaceString);
    }

    private void activateInFindReplaceLogicIf(SearchOptions option, boolean shouldActivate) {
        if (shouldActivate) {
            this.findReplaceLogic.activate(option);
        } else {
            this.findReplaceLogic.deactivate(option);
        }
    }

    private void evaluateFindReplaceStatus() {
        IFindReplaceStatus status = this.findReplaceLogic.getStatus();
        String dialogMessage = status.accept(new FindReplaceLogicMessageGenerator());
        this.fStatusLabel.setText(dialogMessage);
        if (status.isInputValid()) {
            this.fStatusLabel.setForeground(this.fReplaceLabel.getForeground());
        } else {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        }
    }

    private String getCurrentSelection() {
        IFindReplaceTarget target = this.findReplaceLogic.getTarget();
        if (target == null) {
            return null;
        }
        return target.getSelectionText();
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            FindReplaceDialog.this.fActiveShell = (Shell)e.widget;
            FindReplaceDialog.this.updateButtonState();
            if (FindReplaceDialog.this.fGiveFocusToFindField && FindReplaceDialog.this.getShell() == FindReplaceDialog.this.fActiveShell && FindReplaceDialog.this.okToUse((Control)FindReplaceDialog.this.fFindField)) {
                FindReplaceDialog.this.fFindField.setFocus();
            }
        }

        public void shellDeactivated(ShellEvent e) {
            FindReplaceDialog.this.fGiveFocusToFindField = false;
            FindReplaceDialog.this.storeSettings();
            FindReplaceDialog.this.fGlobalRadioButton.setSelection(true);
            FindReplaceDialog.this.fSelectedRangeRadioButton.setSelection(false);
            FindReplaceDialog.this.findReplaceLogic.activate(SearchOptions.GLOBAL);
            IFindReplaceTarget target = FindReplaceDialog.this.findReplaceLogic.getTarget();
            if (target != null && target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).setScope(null);
            }
            FindReplaceDialog.this.fActiveShell = null;
            FindReplaceDialog.this.updateButtonState();
        }
    }

    private class FindModifyListener
    implements ModifyListener {
        private boolean fIgnoreNextEvent;

        private FindModifyListener() {
        }

        private void ignoreNextEvent() {
            this.fIgnoreNextEvent = true;
        }

        public void modifyText(ModifyEvent e) {
            if (this.fIgnoreNextEvent) {
                this.fIgnoreNextEvent = false;
                return;
            }
            if (FindReplaceDialog.this.findReplaceLogic.isActive(SearchOptions.INCREMENTAL)) {
                FindReplaceDialog.this.findReplaceLogic.performSearch(FindReplaceDialog.this.getFindString());
            }
            FindReplaceDialog.this.evaluateFindReplaceStatus();
            FindReplaceDialog.this.updateButtonState(!FindReplaceDialog.this.findReplaceLogic.isActive(SearchOptions.INCREMENTAL));
        }
    }
}

