/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ComponentDocData {
    public final ComplexComponent component;
    public final List<Declaration> variables = Lists.list();
    public final List<Event> uncontrollableEvents = Lists.list();
    public final List<Event> controllableEvents = Lists.list();
    public String edgeVariableName = null;

    public ComponentDocData(ComplexComponent component) {
        this.component = component;
    }

    public void addEvents(Collection<Event> events) {
        for (Event evt : events) {
            if (evt.getControllable().booleanValue()) {
                this.controllableEvents.add(evt);
                continue;
            }
            this.uncontrollableEvents.add(evt);
        }
    }

    public String getComponentName() {
        return CifTextUtils.getAbsName((PositionObject)this.component, (boolean)false);
    }

    public boolean isEmptyVariables() {
        return this.variables.isEmpty() && this.edgeVariableName == null;
    }

    public boolean isEmpty() {
        boolean empty = this.isEmptyVariables();
        if (this.component instanceof Automaton) {
            empty &= this.uncontrollableEvents.isEmpty();
            empty &= this.controllableEvents.isEmpty();
        }
        return empty;
    }

    public void sortData() {
        Collections.sort(this.variables, Comparator.comparing(v -> v.getName()));
        Collections.sort(this.uncontrollableEvents, Comparator.comparing(e -> CifTextUtils.getAbsName((PositionObject)e, (boolean)false)));
        Collections.sort(this.controllableEvents, Comparator.comparing(e -> CifTextUtils.getAbsName((PositionObject)e, (boolean)false)));
    }
}

