/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.SelectChoice;
import org.eclipse.escet.common.java.removablelist.RemovableList;

public class Timer
implements Comparable<Timer> {
    private ChiCoordinator chiCoordinator;
    public final double endTime;
    public final Timer authorativeTimer;
    public RemovableList<SelectChoice> choices = new RemovableList();

    public Timer(ChiCoordinator chiCoordinator) {
        this(chiCoordinator, 0.0);
    }

    public Timer(ChiCoordinator chiCoordinator, double endTime) {
        this.chiCoordinator = chiCoordinator;
        this.endTime = endTime;
        this.authorativeTimer = chiCoordinator.addTimer(this);
    }

    public double getRemaining() {
        double remaining = this.endTime - this.chiCoordinator.getCurrentTime();
        if (remaining < 0.0) {
            return 0.0;
        }
        return remaining;
    }

    public boolean isReady() {
        return this.chiCoordinator.getCurrentTime() >= this.endTime;
    }

    public Timer copyTimer(ChiCoordinator chiCoordinator) {
        Timer t = new Timer(chiCoordinator, this.endTime);
        return t;
    }

    public boolean equals(Object other) {
        if (other instanceof Timer) {
            Timer tother = (Timer)other;
            return this.endTime == tother.endTime;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.endTime);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public int compareTo(Timer other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.endTime < other.endTime) {
            return -1;
        }
        if (this.endTime > other.endTime) {
            return 1;
        }
        return 0;
    }
}

