/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.CompositeEMFOperation;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.lite.commands.AbstractWrappingCommand;

public class CompositeWrappingCommand
extends AbstractWrappingCommand {
    private final CompositeEMFOperation myOperation;

    public CompositeWrappingCommand(TransactionalEditingDomain domain, String label) {
        super(domain);
        this.myOperation = new CompositeEMFOperation(domain, label);
        this.myOperation.setTransactionNestingEnabled(false);
    }

    public void add(Command command) {
        this.myOperation.add((IUndoableOperation)new EMFCommandOperation(this.getEditingDomain(), command));
    }

    public void add(final org.eclipse.gef.commands.Command command) {
        if (command instanceof AbstractWrappingCommand) {
            AbstractWrappingCommand wrappingCommand = (AbstractWrappingCommand)command;
            this.myOperation.add(wrappingCommand.getOperation());
        } else {
            this.myOperation.add((IUndoableOperation)new AbstractOperation(command.getLabel()){

                public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (monitor != null) {
                        monitor.beginTask(command.getLabel(), 1);
                    }
                    try {
                        command.undo();
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }

                public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (monitor != null) {
                        monitor.beginTask(command.getLabel(), 1);
                    }
                    try {
                        command.redo();
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (monitor != null) {
                        monitor.beginTask(command.getLabel(), 1);
                    }
                    try {
                        command.execute();
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }

                public void dispose() {
                    command.undo();
                    super.dispose();
                }

                public boolean canUndo() {
                    return command.canUndo();
                }

                public boolean canRedo() {
                    return command.canExecute();
                }

                public boolean canExecute() {
                    return command.canExecute();
                }
            });
        }
    }

    @Override
    protected IUndoableOperation getOperation() {
        return this.myOperation;
    }
}

