/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.ui.ConverterOptions;
import org.eclipse.gmf.internal.graphdef.codegen.ui.ConverterOutcome;
import org.eclipse.gmf.internal.graphdef.codegen.ui.FigureGeneratorOptionsDialog;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class GeneratePluginAction
implements IObjectActionDelegate,
IInputValidator {
    private List<IFile> mySelectedFiles = Collections.emptyList();
    private IWorkbenchPart myTargetPart;
    private ConverterOptions myOptions;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myTargetPart = targetPart;
    }

    public void run(IAction action) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource[] input = this.loadFromSelection((ResourceSet)rs);
        StandaloneGeneratorOptionsDialog dialog = new StandaloneGeneratorOptionsDialog(this.getShell(), null, true, this);
        if (dialog.open() != 0) {
            return;
        }
        String pluginId = dialog.getPluginId();
        StandaloneGenerator.ConfigImpl config = new StandaloneGenerator.ConfigImpl(pluginId, pluginId, dialog.getMapModeCodeGenStrategy(), dialog.getRuntimeToken());
        ConverterOutcome converterOutcome = new ConverterOutcome(this.getOptions(), input);
        IStatus inputCheck = converterOutcome.checkInputAgainstOptions();
        if (!inputCheck.isOK()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Nothing to do", (String)inputCheck.getMessage());
            return;
        }
        URL[] dynamicTemplates = null;
        if (dialog.getTemplatesPath() != null) {
            try {
                dynamicTemplates = new URL[]{new URL(dialog.getTemplatesPath())};
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Invalid dynamic template path", (String)"Path for dynamic templates is invalid, proceeding without dynamic templates");
            }
        }
        StandaloneGenerator generator = new StandaloneGenerator(converterOutcome.getProcessor(), (StandaloneGenerator.Config)config, dynamicTemplates);
        generator.setSkipPluginStructure(false);
        new Job(action.getText(), (ResourceSet)rs, generator, converterOutcome, (StandaloneGenerator.Config)config){
            private IContainer myResourcesContainer;
            private final /* synthetic */ ResourceSet val$rs;
            private final /* synthetic */ StandaloneGenerator val$generator;
            private final /* synthetic */ ConverterOutcome val$converterOutcome;
            private final /* synthetic */ StandaloneGenerator.Config val$config;
            {
                this.val$rs = resourceSet;
                this.val$generator = standaloneGenerator;
                this.val$converterOutcome = converterOutcome;
                this.val$config = config;
                super($anonymous0);
                this.setUser(true);
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this.val$generator.run(monitor);
                    if (!this.val$generator.getRunStatus().isOK()) {
                        var5_2 = this.val$generator.getRunStatus();
                        return var5_2;
                    }
                    galleryURI = URI.createPlatformResourceURI((String)this.decideOnDestinationFile("bundled").getFullPath().toString(), (boolean)true);
                    canvasURI = URI.createPlatformResourceURI((String)this.decideOnDestinationFile("mirrored").getFullPath().toString(), (boolean)true);
                    var5_3 = this.val$converterOutcome.createResources(this.val$rs, galleryURI, canvasURI);
                    return var5_3;
                }
                catch (InterruptedException v0) {
                    var5_4 = Status.CANCEL_STATUS;
                    return var5_4;
                }
                finally {
                    ** for (next : this.val$rs.getResources())
                }
lbl-1000:
                // 1 sources

                {
                    next.unload();
                    continue;
                }
lbl17:
                // 1 sources

                return var5_4;
            }

            private IFile decideOnDestinationFile(String baseName) {
                Path basePath = new Path(baseName);
                IFile resultFile = this.getResourcesContainer().getFile(basePath.addFileExtension("gmfgraph"));
                int i = 1;
                while (resultFile.exists()) {
                    resultFile = this.getResourcesContainer().getFile(new Path(String.valueOf(basePath.lastSegment()) + String.valueOf(i)).addFileExtension("gmfgraph"));
                    ++i;
                }
                return resultFile;
            }

            private IContainer getResourcesContainer() {
                if (this.myResourcesContainer == null) {
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.val$config.getPluginID());
                    if (!$assertionsDisabled && !p.exists()) {
                        throw new AssertionError();
                    }
                    this.myResourcesContainer = p;
                    IFolder modelsFolder = p.getFolder("models");
                    if (!modelsFolder.exists()) {
                        try {
                            modelsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                            this.myResourcesContainer = modelsFolder;
                        }
                        catch (CoreException coreException) {}
                    }
                }
                return this.myResourcesContainer;
            }
        }.schedule();
    }

    private Resource[] loadFromSelection(ResourceSet rs) {
        Resource[] rv = new Resource[this.mySelectedFiles.size()];
        int i = 0;
        for (IFile next : this.mySelectedFiles) {
            rv[i++] = rs.getResource(URI.createPlatformResourceURI((String)next.getFullPath().toString(), (boolean)true), true);
        }
        return rv;
    }

    public String isValid(String newText) {
        IStatus s = JavaConventions.validatePackageName((String)newText, (String)"1.4", (String)"1.4");
        if (s.isOK()) {
            return null;
        }
        return s.getMessage();
    }

    private Shell getShell() {
        return this.myTargetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelectedFiles = new ArrayList<IFile>(5);
        if (selection instanceof IStructuredSelection) {
            List sel = ((IStructuredSelection)selection).toList();
            this.mySelectedFiles.addAll(sel);
        }
    }

    private ConverterOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = this.loadOptions();
        }
        return this.myOptions;
    }

    private ConverterOptions loadOptions() {
        ConverterOptions options = new ConverterOptions();
        options.needMirroredCanvas = true;
        options.needMirroredGalleries = true;
        return options;
    }

    private static class StandaloneGeneratorOptionsDialog
    extends FigureGeneratorOptionsDialog {
        private IInputValidator pluginIdValidator;
        private Text pluginIdText;
        private String pluginId;
        private String templatesPath;
        private final boolean shouldWarnLiteVerstionDoesNotSupportMapMode;
        private Text templatesPathControl;

        public StandaloneGeneratorOptionsDialog(Shell parentShell, String initialPluginId, boolean initialUseRuntimeFigures, IInputValidator pluginIdValidator) {
            this(parentShell, initialPluginId, initialUseRuntimeFigures, false, pluginIdValidator);
        }

        public StandaloneGeneratorOptionsDialog(Shell parentShell, String initialPluginId, boolean initialUseRuntimeFigures, boolean initialUseMapMode, IInputValidator pluginIdValidator) {
            super(parentShell, "Figure Gallery Generator", initialUseRuntimeFigures, initialUseMapMode);
            this.pluginId = initialPluginId;
            if (this.pluginId == null) {
                this.pluginId = "";
            }
            this.pluginIdValidator = pluginIdValidator;
            this.shouldWarnLiteVerstionDoesNotSupportMapMode = Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") != null;
        }

        @Override
        protected void createControls(Composite result) {
            Label label = new Label(result, 64);
            label.setText("Please specify the name of plug-in/main package");
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            this.pluginIdText = new Text(result, 2052);
            this.pluginIdText.setLayoutData((Object)new GridData(768));
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StandaloneGeneratorOptionsDialog.this.validateInput();
                }
            };
            this.pluginIdText.addModifyListener(modifyListener);
            ExpandableComposite c = new ExpandableComposite(result, 0, 2);
            GridData d = new GridData(4, 128, true, true);
            d.minimumHeight = this.convertVerticalDLUsToPixels(25);
            d.verticalIndent = 10;
            c.setLayoutData((Object)d);
            c.setText("Dynamic templates");
            this.templatesPathControl = new Text((Composite)c, 2052);
            this.templatesPathControl.addModifyListener(modifyListener);
            c.setClient((Control)this.templatesPathControl);
            super.createControls(result);
        }

        protected void validateInput() {
            String errorMessage = null;
            if (this.pluginIdValidator != null) {
                errorMessage = this.pluginIdValidator.isValid(this.pluginIdText.getText());
            }
            if (errorMessage == null && this.templatesPathControl.getText().trim().length() > 0) {
                try {
                    new URL(StandaloneGeneratorOptionsDialog.guessAndResolvePathURL(this.templatesPathControl.getText().trim()));
                }
                catch (Exception exception) {
                    errorMessage = "Illegal dynamic templates path";
                }
            }
            this.setErrorMessage(errorMessage);
        }

        @Override
        protected void warnLiteVerstionDoesNotSupportMapMode() {
            if (this.shouldWarnLiteVerstionDoesNotSupportMapMode) {
                super.warnLiteVerstionDoesNotSupportMapMode();
            }
        }

        @Override
        protected void okPressed() {
            this.pluginId = this.pluginIdText.getText();
            this.templatesPath = this.templatesPathControl.getText().trim();
            this.templatesPath = this.templatesPath.length() == 0 ? null : StandaloneGeneratorOptionsDialog.guessAndResolvePathURL(this.templatesPath);
            super.okPressed();
        }

        private static String guessAndResolvePathURL(String path) {
            assert (path != null);
            URI templatesURI = path.indexOf(58) == -1 ? URI.createPlatformResourceURI((String)path, (boolean)true) : URI.createURI((String)path);
            return CommonPlugin.resolve((URI)templatesURI).toString();
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public String getTemplatesPath() {
            return this.templatesPath;
        }
    }
}

