/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.EnumMap;
import net.atmp.InnerStrategy;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.LineConfigurable;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2;
import net.sourceforge.plantuml.klimt.geom.ULayoutGroup;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockEmpty;
import net.sourceforge.plantuml.klimt.shape.TextBlockLineBefore;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.CornerParam;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;

public class EntityImageObject
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock fields;
    private final Url url;
    private final double roundCorner;
    private final boolean showFields;
    private final LineConfigurable lineConfig;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;

    public EntityImageObject(Entity entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        this.roundCorner = skinParam.getRoundCorner(CornerParam.DEFAULT, null);
        FontConfiguration fcHeader = this.getStyleHeader().getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        TextBlock tmp = this.getUnderlinedName(entity).create(fcHeader, HorizontalAlignment.CENTER, skinParam);
        this.name = TextBlockUtils.withMargin(tmp, 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? null : Display.create(stereotype.getLabels(skinParam.guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.showFields = portionShower.showPortion(EntityPortion.FIELD, entity);
        this.fields = entity.getBodier().getFieldsToDisplay().size() == 0 && this.showFields ? new TextBlockLineBefore(this.getStyle().value(PName.LineThickness).asDouble(), new TextBlockEmpty(10.0, 16.0)) : entity.getBodier().getBody(skinParam, false, this.showFields, entity.getStereotype(), this.getStyle(), null);
        this.url = entity.getUrl99();
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.object).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private Style getStyleHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.object, SName.header).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private Display getUnderlinedName(Entity entity) {
        if (this.getSkinParam().strictUmlStyle()) {
            return entity.getDisplay().underlinedName();
        }
        return entity.getDisplay();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double minClassWidth;
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        XDimension2D dimFields = this.fields.calculateDimension(stringBounder);
        double width = Math.max(dimFields.getWidth(), dimTitle.getWidth() + (double)(2 * this.xMarginCircle));
        if (width < (minClassWidth = this.getStyle().value(PName.MinimumWidth).asDouble())) {
            width = minClassWidth;
        }
        double height = this.getMethodOrFieldHeight(dimFields) + dimTitle.getHeight();
        return new XDimension2D(width, height);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = URectangle.build(widthTotal, heightTotal).rounded(this.roundCorner);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        HColor headerBackcolor = this.getEntity().getColors().getColor(ColorType.HEADER);
        Style style = this.getStyle();
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        if (headerBackcolor == null) {
            HColor hColor = headerBackcolor = backcolor == null ? this.getStyleHeader().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : backcolor;
        }
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        rect.setDeltaShadow(style.value(PName.Shadowing).asDouble());
        UStroke stroke = style.getStroke();
        ug = ug.apply(borderColor).apply(backcolor.bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getName() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getName());
        ug.startGroup(typeIDent);
        ug.apply(stroke).draw(rect);
        if (this.roundCorner == 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            URectangle rect2 = URectangle.build(widthTotal, dimTitle.getHeight());
            UGraphic ugHeader = ug.apply(headerBackcolor.bg());
            ugHeader.apply(stroke).draw(rect2);
        }
        ULayoutGroup header = this.getLayout(stringBounder);
        header.drawU(ug, dimTotal.getWidth(), dimTitle.getHeight());
        UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
        this.fields.drawU(ug2.apply(UTranslate.dy(dimTitle.getHeight())));
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(stringBounder));
        if (this.stereo != null) {
            header.add(this.stereo);
        }
        header.add(this.name);
        return header;
    }

    private double getMethodOrFieldHeight(XDimension2D dim) {
        double fieldsHeight = dim.getHeight();
        if (fieldsHeight == 0.0 && this.showFields) {
            return this.marginEmptyFieldsOrMethod;
        }
        return fieldsHeight;
    }

    private XDimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private XDimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        XDimension2D nameDim = this.name.calculateDimension(stringBounder);
        XDimension2D stereoDim = this.stereo == null ? new XDimension2D(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        XDimension2D nameAndStereo = new XDimension2D(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    @Override
    public ShapeType getShapeType() {
        if (this.getEntity().getPortShortNames().size() > 0) {
            return ShapeType.RECTANGLE_HTML_FOR_PORTS;
        }
        return ShapeType.RECTANGLE;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        XDimension2D dimHeader = this.getNameAndSteretypeDimension(stringBounder);
        if (this.fields instanceof WithPorts) {
            return ((WithPorts)((Object)this.fields)).getPorts(stringBounder).translateY(dimHeader.getHeight());
        }
        return new Ports();
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        UTranslate translate = UTranslate.dy(dimTitle.getHeight());
        return translate.apply(this.fields.getInnerPosition(member, stringBounder, strategy));
    }
}

