/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.dictionary.model.element;

import org.eclipse.epsilon.emc.simulink.dictionary.model.SimulinkDictionaryModel;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.SimulinkSection;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;

public enum SectionEnum {
    DESIGN_DATA("Design Data", "DesignDataEntry"),
    OTHER_DATA("Other Data", "OtherDataEntry"),
    CONFIGURATIONS("Configurations", "ConfigurationsEntry");

    private String MatlabKey;
    private String epsilonEntryName;

    private SectionEnum(String MatlabKey, String epsilonEntryName) {
        this.MatlabKey = MatlabKey;
        this.epsilonEntryName = epsilonEntryName;
    }

    public SimulinkSection getFromModel(SimulinkDictionaryModel model) {
        try {
            HandleObject sectionHandle = (HandleObject)model.getEngine().fevalWithResult("getSection", new Object[]{model.getHandle().getHandle(), this.MatlabKey});
            return new SimulinkSection(model, model.getEngine(), sectionHandle);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMatlabKey() {
        return this.MatlabKey;
    }

    public String getEpsilonEntryName() {
        return this.epsilonEntryName;
    }

    public static SectionEnum forEpsilonEntryType(String type) {
        switch (type) {
            case "DesignDataEntry": {
                return DESIGN_DATA;
            }
            case "OtherDataEntry": {
                return OTHER_DATA;
            }
            case "ConfigurationsEntry": {
                return CONFIGURATIONS;
            }
        }
        return null;
    }

    public static SectionEnum fromMatlab(String property) {
        SectionEnum[] sectionEnumArray = SectionEnum.values();
        int n = sectionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SectionEnum s = sectionEnumArray[n2];
            if (s.MatlabKey.equals(property)) {
                return s;
            }
            ++n2;
        }
        return null;
    }
}

