/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.handler.ESChecksumErrorHandler;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGlobalProjectIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESSessionIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChecksumErrorHandler implements ESChecksumErrorHandler
{
    LOG{

        public boolean execute(ESLocalProject project, ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            WorkspaceUtil.logWarning("Checksum comparison failed.", null);
            return true;
        }
    }
    ,
    CANCEL{

        public boolean execute(ESLocalProject project, ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            return false;
        }
    }
    ,
    AUTOCORRECT{

        public boolean execute(final ESLocalProject project, final ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)project).toInternalAPI();
            Project fetchedProject = (Project)new UnknownEMFStoreWorkloadCommand<Project>(monitor){

                @Override
                public Project run(IProgressMonitor monitor) throws ESException {
                    ESSessionIdImpl sessionIdImpl = (ESSessionIdImpl)project.getUsersession().getSessionId();
                    ESGlobalProjectIdImpl globalProjectIdImpl = (ESGlobalProjectIdImpl)project.getRemoteProject().getGlobalProjectId();
                    ESVersionSpecImpl versionSpecImpl = (ESVersionSpecImpl)versionSpec;
                    return ESWorkspaceProviderImpl.getInstance().getConnectionManager().getProject((SessionId)sessionIdImpl.toInternalAPI(), (ProjectId)globalProjectIdImpl.toInternalAPI(), (VersionSpec)ModelUtil.clone((EObject)((VersionSpec)versionSpecImpl.toInternalAPI())));
                }
            }.execute();
            if (fetchedProject == null) {
                throw new ESException("Server returned a null project!");
            }
            projectSpace.setProject(fetchedProject);
            projectSpace.init();
            return true;
        }
    };


    private ChecksumErrorHandler() {
    }

    /* synthetic */ ChecksumErrorHandler(String string, int n, ChecksumErrorHandler checksumErrorHandler) {
        this();
    }
}

