/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.swt;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.internal.swt.ECPSWTViewImpl;
import org.eclipse.emf.ecp.view.internal.swt.SWTRendererFactoryImpl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.model.reporting.ReportService;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.spi.swt.reporting.InvalidGridDescriptionReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ECPSWTViewRendererImpl
implements ECPSWTViewRenderer {
    private final SWTRendererFactory factory = this.createFactory();

    @Override
    public ECPSWTView render(Composite parent, EObject domainObject) throws ECPRendererException {
        return this.render(parent, domainObject, ViewProviderHelper.getView((EObject)domainObject, null));
    }

    @Override
    public ECPSWTView render(Composite parent, EObject domainObject, VView viewModel) throws ECPRendererException {
        ViewModelContext viewContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)viewModel, domainObject);
        return this.render(parent, viewContext);
    }

    @Override
    public ECPSWTView render(Composite parent, ViewModelContext viewModelContext) throws ECPRendererException {
        AbstractSWTRenderer<VElement> renderer = this.factory.getRenderer(viewModelContext.getViewModel(), viewModelContext);
        ReportService reportService = Activator.getDefault().getReportService();
        SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        if (gridDescription.getGrid().size() != 1) {
            reportService.report((AbstractReport)new InvalidGridDescriptionReport("Invalid number of cells, expected exactly one cell!"));
        }
        ECPSWTViewImpl swtView = null;
        try {
            Composite composite = (Composite)renderer.render((SWTGridCell)((Object)gridDescription.getGrid().get(0)), parent);
            renderer.finalizeRendering(parent);
            GridData gridData = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)gridData);
            swtView = new ECPSWTViewImpl(composite, viewModelContext);
        }
        catch (NoRendererFoundException e) {
            reportService.report((AbstractReport)new RenderingFailedReport(e));
        }
        catch (NoPropertyDescriptorFoundExeption e) {
            reportService.report((AbstractReport)new RenderingFailedReport(e));
        }
        return swtView;
    }

    @Override
    public ECPSWTView render(Composite parent, EObject domainObject, Map<String, Object> context) throws ECPRendererException {
        VView view = ViewProviderHelper.getView((EObject)domainObject, context);
        return this.render(parent, domainObject, view);
    }

    protected SWTRendererFactory createFactory() {
        return new SWTRendererFactoryImpl();
    }
}

