/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.graph;

import org.eclipse.elk.alg.disco.graph.DCDirection;
import org.eclipse.elk.alg.disco.graph.DCElement;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;

public class DCExtension {
    private DCElement parent;
    private DCDirection direction;
    private KVector offset;
    private double width;

    public DCExtension(DCElement parent, DCDirection direction, KVector middlePos, double width) {
        this.parent = parent;
        this.direction = direction;
        this.width = width;
        ElkRectangle bounds = parent.getBounds();
        this.setOffset(new KVector(-bounds.x, -bounds.y));
        this.getOffset().add(middlePos);
        double halfWidth = width / 2.0;
        if (direction.isHorizontal()) {
            this.getOffset().sub(0.0, halfWidth);
        } else {
            this.getOffset().sub(halfWidth, 0.0);
        }
        parent.addExtension(this);
    }

    public DCElement getParent() {
        return this.parent;
    }

    public DCDirection getDirection() {
        return this.direction;
    }

    public KVector getOffset() {
        return this.offset;
    }

    public double getWidth() {
        return this.width;
    }

    private void setOffset(KVector offset) {
        this.offset = offset;
    }
}

