/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial;

import java.util.List;
import org.eclipse.elk.alg.common.NodeMicroLayout;
import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.RadialLayoutPhases;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.radial.options.CompactionStrategy;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class RadialLayoutProvider
extends AbstractLayoutProvider {
    private final AlgorithmAssembler<RadialLayoutPhases, ElkNode> algorithmAssembler = AlgorithmAssembler.create(RadialLayoutPhases.class);

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        List<ILayoutProcessor<ElkNode>> algorithm = this.assembleAlgorithm(layoutGraph);
        progressMonitor.begin("Radial layout", (float)algorithm.size());
        if (!((Boolean)layoutGraph.getProperty(RadialOptions.OMIT_NODE_MICRO_LAYOUT)).booleanValue()) {
            NodeMicroLayout.forGraph((ElkNode)layoutGraph).execute();
        }
        ElkNode root = RadialUtil.findRoot(layoutGraph);
        layoutGraph.setProperty(InternalProperties.ROOT_NODE, (Object)root);
        if (root == null) {
            throw new IllegalArgumentException("The given graph is not a tree!");
        }
        double layoutRadius = (Double)layoutGraph.getProperty(RadialOptions.RADIUS);
        if (layoutRadius == 0.0) {
            layoutRadius = RadialUtil.findLargestNodeInGraph(layoutGraph);
        }
        layoutGraph.setProperty(RadialOptions.RADIUS, (Object)layoutRadius);
        for (ILayoutProcessor<ElkNode> processor : this.assembleAlgorithm(layoutGraph)) {
            processor.process((Object)layoutGraph, progressMonitor.subTask(1.0f));
        }
        progressMonitor.done();
    }

    private List<ILayoutProcessor<ElkNode>> assembleAlgorithm(ElkNode layoutGraph) {
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase((Enum)RadialLayoutPhases.P1_NODE_PLACEMENT, (ILayoutPhaseFactory)RadialLayoutPhases.P1_NODE_PLACEMENT);
        this.algorithmAssembler.setPhase((Enum)RadialLayoutPhases.P2_EDGE_ROUTING, (ILayoutPhaseFactory)RadialLayoutPhases.P2_EDGE_ROUTING);
        LayoutProcessorConfiguration configuration = LayoutProcessorConfiguration.create();
        configuration.addBefore((Enum)RadialLayoutPhases.P2_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.OVERLAP_REMOVAL);
        if (layoutGraph.getProperty(RadialOptions.COMPACTOR) != CompactionStrategy.NONE) {
            configuration.addBefore((Enum)RadialLayoutPhases.P2_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.COMPACTION);
        }
        configuration.addBefore((Enum)RadialLayoutPhases.P2_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.GRAPH_SIZE_CALCULATION);
        this.algorithmAssembler.addProcessorConfiguration(configuration);
        List algorithm = this.algorithmAssembler.build((Object)layoutGraph);
        return algorithm;
    }
}

