/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.firstiteration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.firstiteration.BestCandidateFilter;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.alg.rectpacking.util.DrawingUtil;
import org.eclipse.elk.core.math.ElkPadding;

public class ScaleMeasureFilter
implements BestCandidateFilter {
    @Override
    public List<DrawingData> filterList(List<DrawingData> candidates, double aspectRatio, ElkPadding padding) {
        ArrayList<DrawingData> remainingCandidates = new ArrayList<DrawingData>();
        double maxScale = Double.NEGATIVE_INFINITY;
        for (DrawingData opt : candidates) {
            maxScale = Math.max(maxScale, DrawingUtil.computeScaleMeasure(opt.getDrawingWidth() + padding.getHorizontal(), opt.getDrawingHeight() + padding.getVertical(), opt.getDesiredAspectRatio()));
        }
        for (DrawingData candidate : candidates) {
            if (DrawingUtil.computeScaleMeasure(candidate.getDrawingWidth() + padding.getHorizontal(), candidate.getDrawingHeight() + padding.getVertical(), candidate.getDesiredAspectRatio()) != maxScale) continue;
            remainingCandidates.add(candidate);
        }
        return remainingCandidates;
    }
}

