/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.compaction;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.intermediate.compaction.AbstractRadiusExtensionCompaction;
import org.eclipse.elk.alg.radial.intermediate.compaction.IRadialCompactor;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.alg.radial.options.SortingStrategy;
import org.eclipse.elk.alg.radial.sorting.IRadialSorter;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkNode;

public class AnnulusWedgeCompaction
extends AbstractRadiusExtensionCompaction
implements IRadialCompactor {
    private Multimap<ElkNode, ElkNode> leftContour = HashMultimap.create();
    private Multimap<ElkNode, ElkNode> rightContour = HashMultimap.create();
    private IRadialSorter sorter;
    private ElkNode root;

    @Override
    public void compact(ElkNode graph) {
        this.root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
        this.setRoot(this.root);
        this.sorter = ((SortingStrategy)((Object)graph.getProperty(RadialOptions.SORTER))).create();
        Integer stepSize = (Integer)graph.getProperty(RadialOptions.COMPACTION_STEP_SIZE);
        if (stepSize != null) {
            this.setCompactionStep(stepSize);
        }
        Double spacing = (Double)graph.getProperty(CoreOptions.SPACING_NODE_NODE);
        this.setSpacing(spacing);
        List<ElkNode> successors = RadialUtil.getSuccessors(this.root);
        if (this.sorter != null) {
            this.sorter.sort(successors);
        }
        this.constructContour(successors);
        List<ElkNode> rootList = Arrays.asList(this.root);
        int k = 0;
        while (k < 2) {
            int i = 0;
            while (i < successors.size()) {
                List<ElkNode> nodeAsList = Arrays.asList(successors.get(i));
                ElkNode rightParent = i < successors.size() - 1 ? successors.get(i + 1) : successors.get(0);
                ElkNode leftParent = i == 0 ? successors.get(successors.size() - 1) : successors.get(i - 1);
                this.contractWedge(successors.get(i), rootList, leftParent, rightParent, nodeAsList);
                ++i;
            }
            ++k;
        }
    }

    private void contractWedge(ElkNode wedgeParent, List<ElkNode> predecessors, ElkNode radialPredecessor, ElkNode radialSuccessor, List<ElkNode> currentRadiusNodes) {
        List<ElkNode> nextLevelNodes;
        boolean isOverlapping = this.overlapping(predecessors, radialPredecessor, radialSuccessor, currentRadiusNodes);
        boolean wasContracted = false;
        while (!isOverlapping) {
            this.contractLayer(currentRadiusNodes, true);
            wasContracted = true;
            isOverlapping = this.overlapping(predecessors, radialPredecessor, radialSuccessor, currentRadiusNodes);
        }
        if (wasContracted) {
            this.contractLayer(currentRadiusNodes, false);
        }
        if (!(nextLevelNodes = RadialUtil.getNextLevelNodes(currentRadiusNodes)).isEmpty()) {
            if (this.sorter != null) {
                this.sorter.sort(nextLevelNodes);
            }
            this.contractWedge(wedgeParent, currentRadiusNodes, radialPredecessor, radialSuccessor, nextLevelNodes);
        }
    }

    private boolean overlapping(List<ElkNode> predecessors, ElkNode leftParent, ElkNode rightParent, List<ElkNode> layerNodes) {
        ElkNode firstNode;
        if (this.sorter != null) {
            this.sorter.sort(layerNodes);
        }
        if (this.contourOverlap(leftParent, firstNode = layerNodes.get(0), false)) {
            return true;
        }
        ElkNode lastNode = layerNodes.get(layerNodes.size() - 1);
        if (this.contourOverlap(rightParent, lastNode, true)) {
            return true;
        }
        if (this.overlapLayer(layerNodes)) {
            return true;
        }
        for (ElkNode sortedNode : layerNodes) {
            for (ElkNode predecessor : predecessors) {
                if (!this.overlap(sortedNode, predecessor)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contourOverlap(ElkNode neighbourWedgeParent, ElkNode node, boolean left) {
        Collection contour = left ? this.leftContour.get((Object)neighbourWedgeParent) : this.rightContour.get((Object)neighbourWedgeParent);
        for (ElkNode contourNode : contour) {
            if (!this.overlap(node, contourNode)) continue;
            return true;
        }
        return false;
    }

    private void constructContour(List<ElkNode> nodes) {
        for (ElkNode node : nodes) {
            this.leftContour.put((Object)node, (Object)node);
            this.rightContour.put((Object)node, (Object)node);
            List<ElkNode> successors = RadialUtil.getSuccessors(node);
            if (successors.isEmpty()) continue;
            if (this.sorter != null) {
                this.sorter.sort(successors);
            }
            this.leftContour.put((Object)node, (Object)successors.get(0));
            this.rightContour.put((Object)node, (Object)successors.get(successors.size() - 1));
            while (!RadialUtil.getNextLevelNodes(successors).isEmpty()) {
                successors = RadialUtil.getNextLevelNodes(successors);
                if (this.sorter != null) {
                    this.sorter.sort(successors);
                }
                this.leftContour.put((Object)node, (Object)successors.get(0));
                this.rightContour.put((Object)node, (Object)successors.get(successors.size() - 1));
            }
        }
    }
}

