/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.extension;

import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.extension.PatternFactory;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public abstract class PatternExtension {
    public static final String EXTENSION_ID = "org.eclipse.egf.pattern.extension";

    public abstract PatternNature getNature();

    public abstract PatternFactory getFactory();

    protected abstract AdapterFactory getAdapterFactory();

    protected abstract PatternEngine doCreateRunner(Pattern var1) throws PatternException;

    public PatternEngine createEngine(Pattern pattern) throws PatternException {
        if (!this.matchNature(pattern)) {
            throw new PatternException(Messages.bind((String)Messages.extension_error2, (Object)this.getNature().eClass().getName(), (Object)pattern.getNature().eClass().getName()));
        }
        return this.doCreateRunner(pattern);
    }

    protected abstract PatternInitializer doCreateInitializer(IProject var1, Pattern var2);

    public PatternInitializer createInitializer(IProject project, Pattern pattern) throws PatternException {
        if (!this.matchNature(pattern)) {
            throw new PatternException(Messages.bind((String)Messages.extension_error2, (Object)this.getNature().eClass().getName(), (Object)pattern.getNature().eClass().getName()));
        }
        return this.doCreateInitializer(project, pattern);
    }

    public boolean matchNature(Pattern pattern) {
        if (pattern == null || pattern.getNature() == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNature() == null) {
            throw new IllegalStateException();
        }
        return this.getNature().eClass().equals(pattern.getNature().eClass());
    }

    public final URL getImageURL() {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)this.getNature(), IItemLabelProvider.class);
        return (URL)itemLabelProvider.getImage((Object)this.getNature());
    }

    public String canTranslate(Pattern pattern) {
        IProject project = PatternHelper.getProject(pattern);
        if (project == null) {
            return Messages.assembly_error4;
        }
        IFile file = project.getFile(pattern.getHeaderMethod().getPatternFilePath().path());
        if (!file.exists()) {
            return Messages.assembly_error5;
        }
        return null;
    }

    public String canExecute(Pattern pattern) {
        for (PatternParameter param : pattern.getAllParameters()) {
            if (param.getQuery() != null) continue;
            return Messages.bind((String)Messages.assembly_error9, (Object)param.getName(), (Object)param.getID());
        }
        return null;
    }
}

