/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.manager;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationContext;
import org.eclipse.egf.model.types.TypeAbstractClass;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.context.IOrchestrationProductionContext;
import org.eclipse.egf.producer.internal.context.OrchestrationProductionContext;
import org.eclipse.egf.producer.internal.manager.ModelElementManager;
import org.eclipse.egf.producer.manager.IFactoryComponentManager;
import org.eclipse.egf.producer.manager.IOrchestrationManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public abstract class OrchestrationManager
extends ModelElementManager
implements IOrchestrationManager {
    public OrchestrationManager(IFactoryComponentManager parent, Orchestration orchestration) throws InvocationException {
        super(parent, (ModelElement)orchestration);
    }

    public Orchestration getElement() {
        return (Orchestration)super.getElement();
    }

    public IOrchestrationProductionContext getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    public IFactoryComponentManager getParent() {
        return (IFactoryComponentManager)super.getParent();
    }

    protected abstract OrchestrationProductionContext getInternalProductionContext() throws InvocationException;

    public void initializeContext() throws InvocationException {
        OrchestrationProductionContext context = this.getInternalProductionContext();
        context.clear();
        for (OrchestrationContext orchestrationContext : this.getElement().getOrchestrationContexts()) {
            if (orchestrationContext.getType() == null) continue;
            if (orchestrationContext.getType() instanceof TypeAbstractClass) {
                try {
                    Object object = null;
                    String fqcn = ((TypeAbstractClass)orchestrationContext.getType()).getValue();
                    if (fqcn != null && fqcn.trim().length() != 0 && (object = BundleHelper.instantiate((String)fqcn.trim(), (Bundle)this.getBundle())) == null) {
                        throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)orchestrationContext.getType().getValue(), (Object)this.getBundle().getSymbolicName()), null)));
                    }
                    context.addInputData(orchestrationContext, orchestrationContext.getType().getType(), object);
                    continue;
                }
                catch (Throwable t) {
                    throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)orchestrationContext.getType().getValue()), t)));
                }
            }
            context.addInputData(orchestrationContext, orchestrationContext.getType().getType(), orchestrationContext.getType().getValue());
        }
    }
}

