/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import java.util.Collection;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.ActivityContract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FactoryComponentContract;
import org.eclipse.egf.model.fcore.InvocationContext;
import org.eclipse.egf.producer.context.IFactoryComponentProductionContext;
import org.eclipse.egf.producer.context.IInvocationProductionContext;
import org.eclipse.egf.producer.internal.context.ActivityProductionContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryComponentProductionContext
extends ActivityProductionContext
implements IFactoryComponentProductionContext {
    public FactoryComponentProductionContext(FactoryComponent element, ProjectBundleSession projectBundleSession) {
        super((Activity)element, projectBundleSession);
    }

    public FactoryComponentProductionContext(IInvocationProductionContext parent, FactoryComponent element, ProjectBundleSession projectBundleSession) {
        super(parent, (Activity)element, projectBundleSession);
    }

    @Override
    public FactoryComponent getElement() {
        return (FactoryComponent)super.getElement();
    }

    @Override
    public Class<?> getInputValueType(Object key) throws InvocationException {
        ProductionContext.Data data;
        if (key != null && key instanceof String) {
            return super.getInputValueType(key);
        }
        FactoryComponentContract activityContract = this.getFactoryComponentContract(key, (Collection<ActivityContract>)this.getElement().getActivityContracts(ContractMode.IN));
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_key, (Object)EMFHelper.getText((Object)key), (Object)this.getName()));
        }
        Class valueType = null;
        if (this.getParent() != null) {
            valueType = this.getParent().getInputValueType(activityContract);
        }
        if (valueType == null && (data = (ProductionContext.Data)this._inputDatas.get(activityContract)) != null) {
            valueType = data.getType();
        }
        return valueType;
    }

    @Override
    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        ProductionContext.Data data;
        if (key != null && key instanceof String) {
            return super.getInputValue(key, clazz);
        }
        FactoryComponentContract activityContract = this.getFactoryComponentContract(key, (Collection<ActivityContract>)this.getElement().getActivityContracts(ContractMode.IN));
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_key, (Object)EMFHelper.getText((Object)key), (Object)this.getName()));
        }
        Object value = null;
        if (this.getParent() != null) {
            value = this.getParent().getInputValue(activityContract, clazz);
        }
        if (value == null && (data = (ProductionContext.Data)this._inputDatas.get(activityContract)) != null) {
            value = this.getValue(activityContract, clazz, data);
        }
        return (R)value;
    }

    @Override
    public Class<?> getOutputValueType(Object key) throws InvocationException {
        ProductionContext.Data data;
        if (key != null && key instanceof String) {
            return super.getOutputValueType(key);
        }
        FactoryComponentContract activityContract = this.getFactoryComponentContract(key, (Collection<ActivityContract>)this.getElement().getActivityContracts(ContractMode.OUT));
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_key, (Object)EMFHelper.getText((Object)key), (Object)this.getName()));
        }
        Class valueType = null;
        if (this.getParent() != null) {
            valueType = this.getParent().getOutputValueType(activityContract);
        }
        if (valueType == null && (data = (ProductionContext.Data)this._outputDatas.get(activityContract)) != null) {
            valueType = data.getType();
        }
        return valueType;
    }

    @Override
    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        ProductionContext.Data data;
        if (key != null && key instanceof String) {
            return super.getOutputValue(key, clazz);
        }
        FactoryComponentContract activityContract = this.getFactoryComponentContract(key, (Collection<ActivityContract>)this.getElement().getActivityContracts(ContractMode.OUT));
        if (activityContract == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_key, (Object)EMFHelper.getText((Object)key), (Object)this.getName()));
        }
        Object value = null;
        if (this.getParent() != null) {
            value = this.getParent().getOutputValue(activityContract, clazz);
        }
        if (value == null && (data = (ProductionContext.Data)this._outputDatas.get(activityContract)) != null) {
            value = this.getValue(activityContract, clazz, data);
        }
        return (R)value;
    }

    @Override
    public void setOutputValue(Object key, Object value) throws InvocationException {
        ProductionContext.Data data;
        FactoryComponentContract activityContract;
        if (key != null && key instanceof String) {
            super.setOutputValue(key, value);
        }
        if ((activityContract = this.getFactoryComponentContract(key, (Collection<ActivityContract>)this.getElement().getActivityContracts(ContractMode.OUT))) == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_key, (Object)EMFHelper.getText((Object)key), (Object)this.getName()));
        }
        if (this.getParent() != null) {
            this.getParent().setOutputValue(activityContract, value);
        }
        if ((data = (ProductionContext.Data)this._outputDatas.get(activityContract)) == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_unknown_key, (Object)EMFHelper.getText((Object)key), (Object)this.getName()));
        }
        if (!(value == null || ClassHelper.asSubClass(value.getClass(), (Class)data.getType()) && data.getType().isInstance(value))) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{data.getType().getName(), EMFHelper.getText((Object)key), value.getClass().getName(), this.getName()}));
        }
        data.setValue(value);
    }

    private FactoryComponentContract getFactoryComponentContract(Object key, Collection<ActivityContract> keys) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
        }
        if (!(key instanceof InvocationContext)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{InvocationContext.class.getName(), EMFHelper.getText((Object)key), key.getClass().getName(), this.getName()}));
        }
        FactoryComponentContract factoryComponentContract = null;
        for (ActivityContract activityContract : keys) {
            FactoryComponentContract innerFactoryComponentContract;
            if (!(activityContract instanceof FactoryComponentContract) || !(innerFactoryComponentContract = (FactoryComponentContract)activityContract).getInvocationContexts().contains(key)) continue;
            factoryComponentContract = innerFactoryComponentContract;
            break;
        }
        return factoryComponentContract;
    }
}

