/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ProjectHelper {
    protected static final String CLASS_PATH_ENTRY_REQUIRED_PLUGINS_PATH_ID = "requiredPlugins";

    private ProjectHelper() {
    }

    public static IProject getProject(String pluginId) {
        if (pluginId == null) {
            return null;
        }
        IPluginModelBase modelBase = PluginRegistry.findModel((String)pluginId);
        if (modelBase == null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(pluginId);
        }
        return ProjectHelper.getProject(modelBase);
    }

    public static IProject getProject(IPluginModelBase base) {
        if (base == null) {
            return null;
        }
        IResource underlyingResource = base.getUnderlyingResource();
        if (underlyingResource != null) {
            return underlyingResource.getProject();
        }
        return null;
    }

    public static void refreshProject(IProject project_p, IProgressMonitor monitor_p) {
        ProjectHelper.refreshProject(project_p, 2, monitor_p);
    }

    public static void refreshProject(IProject projectToRefresh_p, int depth_p, IProgressMonitor monitor_p) {
        try {
            projectToRefresh_p.refreshLocal(depth_p, monitor_p);
        }
        catch (CoreException ce) {
            StringBuilder msg = new StringBuilder("ProjectHelper.refreshProject(..) _ ");
            EGFCommonPlugin.getDefault().logError(msg.toString(), ce);
        }
    }

    public static boolean createSourceFolder(String sourceFolderName_p, IProject project_p, IProgressMonitor monitor_p) {
        boolean successful = false;
        if (sourceFolderName_p == null || project_p == null || monitor_p == null) {
            return successful;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project_p);
            IClasspathEntry[] sourceEntries = javaProject.getRawClasspath();
            IPath generatedSourceFolderPath = project_p.getFullPath().append(sourceFolderName_p);
            ProjectHelper.createFolder(sourceFolderName_p, project_p, (IProgressMonitor)new SubProgressMonitor(monitor_p, 1));
            IClasspathEntry generatedSourceEntry = JavaCore.newSourceEntry((IPath)generatedSourceFolderPath);
            IClasspathEntry[] newEntries = new IClasspathEntry[sourceEntries.length + 1];
            newEntries[0] = sourceEntries[0];
            newEntries[1] = generatedSourceEntry;
            System.arraycopy(sourceEntries, 1, newEntries, 2, sourceEntries.length - 1);
            javaProject.setRawClasspath(newEntries, (IProgressMonitor)new SubProgressMonitor(monitor_p, 1));
            successful = true;
        }
        catch (Exception e) {
            successful = false;
            StringBuilder msg = new StringBuilder("ProjectHelper.createSourceFolder(..) _ ");
            EGFCommonPlugin.getDefault().logError(msg.toString(), e);
        }
        return successful;
    }

    public static IFolder createFolder(String folderName_p, IProject project_p, IProgressMonitor monitor_p) {
        IFolder folder = project_p.getFolder(folderName_p);
        if (!folder.exists()) {
            Path parentPath = new Path(folderName_p);
            if (parentPath.segmentCount() > 1) {
                parentPath = parentPath.removeLastSegments(1);
                ProjectHelper.createFolder(parentPath.toString(), project_p, monitor_p);
            }
            try {
                folder.create(true, true, monitor_p);
            }
            catch (CoreException ce) {
                folder = null;
                StringBuilder msg = new StringBuilder("ProjectHelper.createFolder(..) _ ");
                EGFCommonPlugin.getDefault().logError(msg.toString(), ce);
            }
        }
        return folder;
    }

    private static ProjectExistenceStatus ensureProjectExists(String projectName_p, boolean cleanProject_p, int projectType_p) {
        ProjectExistenceStatus result = ProjectExistenceStatus.CREATION_FAILED;
        if (projectName_p == null) {
            return result;
        }
        IFile file = FileHelper.getPlatformFile(String.valueOf(projectName_p) + "/META-INF/MANIFEST.MF");
        if (file.exists()) {
            return ProjectExistenceStatus.ALREADY_EXISTS;
        }
        Path projectLocationPath = new Path(String.valueOf('/') + projectName_p);
        IProject resultingProject = Generator.createEMFProject((IPath)projectLocationPath.append("/src"), null, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor(), (int)projectType_p, (List)Collections.EMPTY_LIST);
        if (resultingProject != null && resultingProject.exists()) {
            result = ProjectExistenceStatus.CREATED;
            if (cleanProject_p) {
                ProjectHelper.cleanProjectStructure(resultingProject);
            }
        } else {
            result = ProjectExistenceStatus.CREATION_FAILED;
        }
        return result;
    }

    private static void cleanProjectStructure(IProject project_p) {
        IJavaProject javaProject = JavaCore.create((IProject)project_p);
        if (javaProject == null) {
            return;
        }
        String[] natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
        try {
            IProjectDescription description = project_p.getDescription();
            description.setNatureIds(natureIds);
            project_p.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            StringBuilder msg = new StringBuilder("ProjectHelper.cleanProjectStructure(..) _ ");
            EGFCommonPlugin.getDefault().logError(msg.toString(), ce);
        }
        IClasspathEntry[] rawClasspath = null;
        try {
            rawClasspath = javaProject.getRawClasspath();
        }
        catch (JavaModelException jme) {
            StringBuilder msg = new StringBuilder("ProjectHelper.cleanProjectStructure(..) _ ");
            EGFCommonPlugin.getDefault().logError(msg.toString(), jme);
        }
        if (rawClasspath != null && rawClasspath.length != 0) {
            ArrayList<IClasspathEntry> newRawClasspath = new ArrayList<IClasspathEntry>(rawClasspath.length);
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 5) {
                    IPath path = classpathEntry.getPath();
                    if (!CLASS_PATH_ENTRY_REQUIRED_PLUGINS_PATH_ID.equals(path.getFileExtension())) {
                        newRawClasspath.add(classpathEntry);
                    }
                } else {
                    newRawClasspath.add(classpathEntry);
                }
                ++n2;
            }
            try {
                javaProject.setRawClasspath(newRawClasspath.toArray(new IClasspathEntry[newRawClasspath.size()]), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException jme) {
                StringBuilder msg = new StringBuilder("ProjectHelper.cleanProjectStructure(..) _ ");
                EGFCommonPlugin.getDefault().logError(msg.toString(), jme);
            }
        }
    }

    public static ProjectExistenceStatus ensurePluginProjectExists(String projectName_p) {
        return ProjectHelper.ensureProjectExists(projectName_p, false, Generator.EMF_PLUGIN_PROJECT_STYLE);
    }

    public static ProjectExistenceStatus ensureProjectExists(String projectName_p) {
        return ProjectHelper.ensureProjectExists(projectName_p, true, Generator.EMF_EMPTY_PROJECT_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectExistenceStatus {
        ALREADY_EXISTS,
        CREATED,
        CREATION_FAILED;

    }
}

