/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.PatternMethodEditorInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;

public class PatternTemplateEditor
extends MultiPageEditorPart {
    private final Map<String, TextEditor> editors = new HashMap<String, TextEditor>();

    void createPage(PatternMethod method) {
        try {
            TextEditor editor = new TextEditor();
            int index = this.addPage((IEditorPart)editor, (IEditorInput)new PatternMethodEditorInput(method.eResource(), method.getID()));
            this.setPageText(index, method.getName());
            this.editors.put(method.getID(), editor);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
            Activator.getDefault().logError(e);
        }
    }

    protected void createPages() {
        for (PatternMethod method : this.getPattern().getMethods()) {
            this.createPage(method);
        }
    }

    public IEditorPart getEditorPart(String methodId) {
        return (IEditorPart)this.editors.get(methodId);
    }

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.getPageCount()) {
            this.getEditor(i).doSave(monitor);
            ++i;
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof PatternEditorInput)) {
            throw new PartInitException(Messages.Editor_wrong_input);
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private Pattern getPattern() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getPattern();
    }

    public void setActiveEditor(String methodId) {
        IEditorPart editorPart = this.getEditorPart(methodId);
        if (editorPart != null) {
            super.setActiveEditor(editorPart);
        }
    }

    public static void openEditor(IWorkbenchPage page, Pattern pattern, String methodId) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        Resource resource = pattern.eResource();
        try {
            PatternEditorInput input = new PatternEditorInput(resource, pattern.getID());
            PatternTemplateEditor editor = (PatternTemplateEditor)IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.egf.pattern.ui.editors.PatternTemplateEditor");
            editor.setActiveEditor(methodId);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

