/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.ui.contributor.ViewpointContributor;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.PatternEditor;
import org.eclipse.egf.pattern.ui.editors.PatternTemplateEditor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class PatternViewpointContributor
extends ViewpointContributor {
    public static final String EDIT_ACTION_ID = "edit-pattern";
    public static final String EDIT_TEMPLATE_ACTION_ID = "edit-template-pattern";
    private final EditPatternAction editAction = new EditPatternAction();
    private final EditTemplatePatternAction editTemplateAction = new EditTemplatePatternAction();

    private boolean addActions() {
        if (this.selection == null) {
            return false;
        }
        IStructuredSelection sselection = (IStructuredSelection)this.selection;
        return sselection.size() == 1 && sselection.getFirstElement() instanceof PatternElement;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        IStructuredSelection selection2 = (IStructuredSelection)this.selection;
        if (this.addActions()) {
            if (selection2.getFirstElement() instanceof PatternLibrary) {
                IContributionItem item = menuManager.find("create-child");
                MenuManager createChildMenuManager = null;
                if (item != null && item instanceof MenuManager) {
                    createChildMenuManager = (MenuManager)item;
                } else {
                    createChildMenuManager = new MenuManager(Messages.ViewpointContributor_newChildGroup_label);
                    menuManager.insertBefore("create-sibling", (IContributionItem)createChildMenuManager);
                }
                Map extensions = ExtensionHelper.getExtensions();
                for (String nature : extensions.keySet()) {
                    PatternExtension patternExtension = (PatternExtension)extensions.get(nature);
                    CommandParameter descriptor = new CommandParameter(null, (Object)PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS, (Object)patternExtension.getFactory().createPattern(null, "myPattern"));
                    CreatePatternAction createChildAction = new CreatePatternAction(this.activeEditorPart, this.selection, descriptor, (PatternLibrary)selection2.getFirstElement());
                    createChildAction.setText(Messages.bind((String)Messages.ViewpointContributor_newPattern_label, (Object)nature));
                    createChildAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)patternExtension.getImageURL()));
                    createChildMenuManager.add((IAction)createChildAction);
                }
            } else if (selection2.getFirstElement() instanceof Pattern) {
                menuManager.insertBefore("edit", (IAction)this.editAction);
                menuManager.insertBefore("edit", (IAction)this.editTemplateAction);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreatePatternAction
    extends CreateChildAction {
        private final PatternLibrary library;

        public CreatePatternAction(IEditorPart editorPart, ISelection selection, Object descriptor, PatternLibrary library) {
            super(editorPart, selection, descriptor);
            this.library = library;
        }

        protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
            final Command createActionCommand = super.createActionCommand(editingDomain, collection);
            if (UnexecutableCommand.INSTANCE.equals(createActionCommand)) {
                return UnexecutableCommand.INSTANCE;
            }
            return createActionCommand.chain((Command)new AbstractCommand(){

                protected boolean prepare() {
                    return true;
                }

                public void execute() {
                    Collection affectedObjects = createActionCommand.getAffectedObjects();
                    Pattern pattern = (Pattern)affectedObjects.iterator().next();
                    for (PatternMethod m : pattern.getMethods()) {
                        m.setPatternFilePath(PatternHelper.Filename.computeFileURI((PatternMethod)m));
                    }
                    IProject project = EGFCorePlugin.getPlatformFcore((Resource)CreatePatternAction.this.library.eResource()).getPlatformBundle().getProject();
                    try {
                        PatternInitializer initializer = ExtensionHelper.getExtension((PatternNature)pattern.getNature()).createInitializer(project, pattern);
                        initializer.initContent();
                    }
                    catch (PatternException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (ExtensionHelper.MissingExtensionException e) {
                        Activator.getDefault().logError(e);
                    }
                }

                public void undo() {
                    Collection affectedObjects = createActionCommand.getAffectedObjects();
                    Pattern pattern = (Pattern)affectedObjects.iterator().next();
                    IProject project = EGFCorePlugin.getPlatformFcore((Resource)CreatePatternAction.this.library.eResource()).getPlatformBundle().getProject();
                    IFile currentFile = null;
                    try {
                        for (PatternMethod m : pattern.getMethods()) {
                            currentFile = project.getFile(m.getPatternFilePath().path());
                            currentFile.delete(true, false, null);
                        }
                        if (currentFile != null && currentFile.getParent() != null) {
                            currentFile.getParent().delete(true, null);
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(e);
                    }
                }

                public void redo() {
                }
            });
        }
    }

    private final class EditPatternAction
    extends PatternAction {
        public EditPatternAction() {
            super(Messages.ViewpointContributor_editAction_label, PatternViewpointContributor.EDIT_ACTION_ID);
        }

        public void run() {
            Pattern patternInTransactionalEditingDomain = this.getPatternInTransactionalEditingDomain();
            if (patternInTransactionalEditingDomain == null) {
                MessageDialog.openInformation((Shell)PatternViewpointContributor.this.parent.getPage().getWorkbenchWindow().getShell(), (String)Messages.ViewpointContributor_missingPattern_title, (String)Messages.ViewpointContributor_missingPattern_message);
            } else {
                PatternEditor.openEditor(PatternViewpointContributor.this.parent.getPage(), patternInTransactionalEditingDomain);
            }
        }
    }

    private final class EditTemplatePatternAction
    extends PatternAction {
        public EditTemplatePatternAction() {
            super(Messages.ViewpointContributor_editTemplateAction_label, PatternViewpointContributor.EDIT_TEMPLATE_ACTION_ID);
        }

        public void run() {
            Pattern patternInTransactionalEditingDomain = this.getPatternInTransactionalEditingDomain();
            if (patternInTransactionalEditingDomain == null) {
                MessageDialog.openInformation((Shell)PatternViewpointContributor.this.parent.getPage().getWorkbenchWindow().getShell(), (String)Messages.ViewpointContributor_missingPattern_title, (String)Messages.ViewpointContributor_missingPattern_message);
            } else {
                PatternTemplateEditor.openEditor(PatternViewpointContributor.this.parent.getPage(), patternInTransactionalEditingDomain, null);
            }
        }
    }

    private abstract class PatternAction
    extends Action {
        public PatternAction(String label, String id) {
            super(label);
            this.setId(id);
        }

        protected Pattern getPattern() {
            if (PatternViewpointContributor.this.selection == null) {
                throw new IllegalStateException();
            }
            IStructuredSelection sselection = (IStructuredSelection)PatternViewpointContributor.this.selection;
            if (sselection.size() != 1 || !(sselection.getFirstElement() instanceof Pattern)) {
                throw new IllegalStateException();
            }
            return (Pattern)sselection.getFirstElement();
        }

        protected Pattern getPatternInTransactionalEditingDomain() {
            Pattern pattern = this.getPattern();
            return PatternHelper.TRANSACTIONNAL_COLLECTOR.getPattern(pattern.getID());
        }
    }

    private final class TestAction
    extends Action {
        public TestAction(String text) {
            super(text);
            this.setId(text);
        }

        public void run() {
            super.run();
        }
    }
}

