/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.internal.plugin;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.egf.core.pde.internal.FcoreGeneratorHelper;
import org.eclipse.egf.core.pde.internal.ui.ModelModification;
import org.eclipse.egf.core.pde.internal.ui.PDEModelUtility;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommand;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommandRunner;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginChangesCommandRunner
implements IPluginChangesCommandRunner {
    private static final String PLUGIN_VERSION_3_0 = "3.0";
    private static final String PLUGIN_VERSION_3_2 = "3.2";

    @Override
    public void performChangesOnPlugin(String bundleId_p, List<IPluginChangesCommand> commands_p) {
        if (bundleId_p == null) {
            StringBuffer msg = new StringBuffer("PluginChangesCommandRunner.performChangesOnPlugin(..) _ ");
            msg.append("bundleId_p can't be null");
            EGFPDEPlugin.getDefault().logError(msg.toString());
            return;
        }
        IPluginModelBase model = PluginRegistry.findModel((String)bundleId_p);
        if (model != null && this.bundleFileExists(model, "plugin.xml", bundleId_p)) {
            this.modifyExistingPlugin(commands_p, model, "plugin.xml", bundleId_p);
        } else if (model != null) {
            this.createNewPlugin(commands_p, model, bundleId_p);
        }
        this.updateSingleton(model, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void performChangesOnManifest(String bundleId_p, List<IPluginChangesCommand> commands_p) {
        if (bundleId_p == null) {
            StringBuffer msg = new StringBuffer("PluginChangesCommandRunner.performChangesOnManifest(..) _ ");
            msg.append("bundleId_p can't be null");
            EGFPDEPlugin.getDefault().logError(msg.toString());
            return;
        }
        IPluginModelBase bundleModel = PluginRegistry.findModel((String)bundleId_p);
        if (this.bundleFileExists(bundleModel, "META-INF/MANIFEST.MF", bundleId_p)) {
            this.modifyExistingPlugin(commands_p, bundleModel, "META-INF/MANIFEST.MF", bundleId_p);
        }
    }

    private void createNewPlugin(List<IPluginChangesCommand> commands_p, IPluginModelBase bundleModel_p, String bundleId_p) {
        WorkspacePluginModelBase pluginModel = this.createPluginModel(bundleModel_p, bundleId_p);
        for (IPluginChangesCommand command : commands_p) {
            command.setPluginModelBase((IPluginModelBase)pluginModel);
            command.execute();
        }
        this.updateBuildFile(pluginModel);
        this.save((IPluginModelBase)pluginModel);
    }

    private void updateBuildFile(WorkspacePluginModelBase pluginModel_p) {
        IBuildModel buildModel = pluginModel_p.getBuildModel();
        IProject project = pluginModel_p.getUnderlyingResource().getProject();
        if (buildModel == null) {
            buildModel = FcoreGeneratorHelper.getBuildModel(project);
            pluginModel_p.setBuildModel(buildModel);
        }
        FcoreGeneratorHelper.addEntryInBinaryBuild(buildModel, "plugin.xml");
        ((WorkspaceBuildModel)buildModel).save();
    }

    private void save(IPluginModelBase pluginModelBase_p) {
        if (pluginModelBase_p instanceof WorkspacePluginModelBase) {
            WorkspacePluginModelBase plugin = (WorkspacePluginModelBase)pluginModelBase_p;
            plugin.save();
        }
    }

    private void modifyExistingPlugin(final List<IPluginChangesCommand> commands_p, IPluginModelBase bundleModel_p, String bundleRelativeFileName_p, String bundleId_p) {
        final IFile file = PluginChangesCommandRunner.getFile(bundleModel_p, bundleRelativeFileName_p, bundleId_p);
        Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                ModelModification updateOperation = new ModelModification(file){

                    protected void modifyModel(IBaseModel model_p, IProgressMonitor monitor_p) throws CoreException {
                        if (!(model_p instanceof IPluginModelBase)) {
                            return;
                        }
                        IPluginModelBase pluginModel = (IPluginModelBase)model_p;
                        for (IPluginChangesCommand command : commands_p) {
                            command.setPluginModelBase(pluginModel);
                            command.execute();
                        }
                    }
                };
                PDEModelUtility.modifyModel(updateOperation, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    protected Display getDisplay() {
        Display display = null;
        display = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getDisplay() : Display.getDefault();
        return display;
    }

    private void updateSingleton(IPluginModelBase bundleModel_p, IProgressMonitor monitor_p) {
        if (bundleModel_p instanceof IBundlePluginModel) {
            IFile file = (IFile)bundleModel_p.getUnderlyingResource();
            ModelModification modification = new ModelModification(file){

                protected void modifyModel(IBaseModel model_p, IProgressMonitor progressMonitor_p) throws CoreException {
                    BundleSymbolicNameHeader symbolic;
                    if (!(model_p instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase modelBase = (IBundlePluginModelBase)model_p;
                    IBundle bundle = modelBase.getBundleModel().getBundle();
                    IManifestHeader header = bundle.getManifestHeader("Bundle-SymbolicName");
                    if (header instanceof BundleSymbolicNameHeader && !(symbolic = (BundleSymbolicNameHeader)header).isSingleton()) {
                        symbolic.setSingleton(true);
                    }
                }
            };
            PDEModelUtility.modifyModel(modification, monitor_p);
        }
    }

    private WorkspacePluginModelBase createPluginModel(IPluginModelBase model_p, String bundleId_p) {
        IFile pluginFile = PluginChangesCommandRunner.getFile(model_p, "plugin.xml", bundleId_p);
        WorkspacePluginModelBase pluginModel = null;
        try {
            pluginModel = (WorkspacePluginModelBase)this.getModel(pluginFile);
            IPluginBase plugin = pluginModel.getPluginBase();
            plugin.setSchemaVersion(TargetPlatformHelper.getTargetVersion() < 3.2 ? PLUGIN_VERSION_3_0 : PLUGIN_VERSION_3_2);
        }
        catch (CoreException ce) {
            EGFPDEPlugin.getDefault().logError(new String("AbstractExtensionHelper.createNewPlugin(..) _ "), ce);
        }
        return pluginModel;
    }

    private boolean bundleFileExists(IPluginModelBase model_p, String bundleRelativeFileName_p, String bundleId_p) {
        boolean result = false;
        IFile file = PluginChangesCommandRunner.getFile(model_p, bundleRelativeFileName_p, bundleId_p);
        if (file != null) {
            result = file.exists();
        }
        return result;
    }

    private IPluginModelBase getModel(IFile file) {
        if ("plugin.xml".equals(file.getName())) {
            return new WorkspacePluginModel(file, false);
        }
        if ("fragment.xml".equals(file.getName())) {
            return new WorkspaceFragmentModel(file, false);
        }
        return null;
    }

    private static IFile getFile(IPluginModelBase pluginModelBase_p, String bundleRelativeFileName_p) {
        IFile result = null;
        if (pluginModelBase_p == null) {
            return result;
        }
        IProject project = ProjectHelper.getProject((IPluginModelBase)pluginModelBase_p);
        result = project.getFile(bundleRelativeFileName_p);
        return result;
    }

    private static IFile getFile(IPluginModelBase pluginModelBase_p, String bundleRelativeFileName_p, String bundleId_p) {
        IProject project;
        IFile result = PluginChangesCommandRunner.getFile(pluginModelBase_p, bundleRelativeFileName_p);
        if (result == null && (project = ProjectHelper.getProject((String)bundleId_p)) != null) {
            result = project.getFile(bundleRelativeFileName_p);
        }
        return result;
    }
}

