/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;

public class Utils {
    private static final SimpleDateFormat formatTimeOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat sameYearFormatTimeOut = new SimpleDateFormat("MMM dd HH:mm");
    private static final SimpleDateFormat sameDayFormatTimeOut = new SimpleDateFormat("HH:mm aa");
    private static final SimpleDateFormat differentYearFormatTimeOut = new SimpleDateFormat("MMM dd, yyyy");

    private Utils() {
    }

    public static String formatDate(String inDate, SimpleDateFormat formatOut) {
        SimpleDateFormat formatIn = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
        Date dateNew = null;
        try {
            formatIn.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateNew = formatIn.parse(inDate);
        }
        catch (ParseException ex) {
            EGerritCorePlugin.logError(ex.getMessage());
        }
        return formatOut.format(dateNew);
    }

    public static String prettyPrintDate(String inDate) {
        Date date = null;
        long hourMSec = 3600000L;
        try {
            formatTimeOut.setTimeZone(TimeZone.getTimeZone("UTC"));
            date = formatTimeOut.parse(inDate);
        }
        catch (ParseException e) {
            EGerritCorePlugin.logError(e.getMessage());
            return "";
        }
        boolean sameDay = DateUtils.isSameDay((Date)date, (Date)Calendar.getInstance().getTime());
        Calendar today = Calendar.getInstance();
        Calendar currentReview = Calendar.getInstance();
        long diffMSec = today.getTimeInMillis() - date.getTime();
        currentReview.setTime(date);
        if (sameDay || diffMSec <= 6L * hourMSec) {
            return Utils.formatDate(inDate, sameDayFormatTimeOut);
        }
        if (today.get(1) != currentReview.get(1)) {
            return Utils.formatDate(inDate, differentYearFormatTimeOut);
        }
        return Utils.formatDate(inDate, sameYearFormatTimeOut);
    }
}

