/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.refactoring;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fx.ide.jdt.ui.internal.refactoring.RefactoringUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class JFXDeleteParticipant
extends DeleteParticipant {
    private IFile deletedElement;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.deletedElement = (IFile)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "e(fx)clipse JFXDeleteParticipant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        final HashMap changes = new HashMap();
        this.deletedElement.getProject().findMember(this.deletedElement.getProjectRelativePath());
        if (this.deletedElement != null) {
            IProject[] roots = this.deletedElement.getWorkspace().getRoot().getProjects();
            String[] fileNamePatterns = new String[]{"*.fxbuild"};
            FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePatterns, (boolean)false);
            String oldType = RefactoringUtil.buildFullyQualifiedName((IResource)this.deletedElement);
            Pattern pattern = Pattern.compile(oldType);
            TextSearchRequestor collector = new TextSearchRequestor(){

                public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                    IFile file = matchAccess.getFile();
                    TextFileChange change = (TextFileChange)changes.get(file);
                    if (change == null) {
                        TextChange textChange = JFXDeleteParticipant.this.getTextChange(file);
                        if (textChange != null) {
                            return false;
                        }
                        change = new TextFileChange(file.getName(), file);
                        change.setEdit((TextEdit)new MultiTextEdit());
                        changes.put(file, change);
                    }
                    ReplaceEdit edit = new ReplaceEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength(), "");
                    change.addEdit((TextEdit)edit);
                    change.addTextEditGroup(new TextEditGroup("Remove type reference", (TextEdit)edit));
                    return true;
                }
            };
            TextSearchEngine.create().search((TextSearchScope)scope, collector, pattern, pm);
        }
        if (changes.isEmpty()) {
            return null;
        }
        CompositeChange result = new CompositeChange("FX build configuration updates");
        for (Change change : changes.values()) {
            result.add(change);
        }
        return result;
    }
}

