/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.fx.ide.fxgraph.converter.FXGraphConverter;
import org.eclipse.fx.ide.fxgraph.converter.FXMLLoader;
import org.eclipse.fx.ide.fxgraph.converter.IFXMLFile;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.text.edits.TextEdit;

public class ConvertFXMLHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object o;
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        ISelection s = (ISelection)context.getVariable("activeMenuSelection");
        if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof IFile) {
            IFile f = (IFile)o;
            IContainer folder = f.getParent();
            IFile outFile = folder.getFile((IPath)new Path(String.valueOf(f.getName().substring(0, f.getName().length() - f.getFileExtension().length() - 1)) + this.getTargetFileExtension()));
            String content = this.convert(outFile, f);
            IProject project = outFile.getProject();
            Object codeFormatter = ConvertFXMLHandler.createCodeFormatter(project);
            if (codeFormatter != null) {
                content = this.format(content, (CodeFormatter)codeFormatter);
            }
            if (!outFile.exists()) {
                try {
                    outFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    outFile.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), 3, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected String convert(IFile outFile, final IFile file) throws ExecutionException {
        FXMLLoader loader = new FXMLLoader();
        Model m = loader.loadModel(new IFXMLFile(){

            public String getPackagename() {
                String packName = null;
                IJavaElement j = JavaCore.create((IResource)file.getParent());
                if (j instanceof IPackageFragment) {
                    IPackageFragment p = (IPackageFragment)j;
                    packName = p.getElementName();
                }
                return packName;
            }

            public String getName() {
                return file.getName();
            }

            public InputStream getContent() {
                try {
                    return file.getContents();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return new FXGraphConverter().generate(m).toString();
    }

    protected String getTargetFileExtension() {
        return ".fxgraph";
    }

    protected String format(String contents, CodeFormatter codeFormatter) {
        Document doc;
        TextEdit edit;
        if (codeFormatter instanceof CodeFormatter && (edit = codeFormatter.format(8, (doc = new Document(contents)).get(), 0, doc.get().length(), 0, null)) != null) {
            try {
                edit.apply((IDocument)doc);
                contents = doc.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return contents;
    }

    public static Object createCodeFormatter(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Map options = javaProject.getOptions(true);
        return ToolFactory.createCodeFormatter((Map)options);
    }
}

