/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.converter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractConverterHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object o;
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        ISelection s = (ISelection)context.getVariable("activeMenuSelection");
        if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof IFile) {
            IFile f = (IFile)o;
            IContainer folder = f.getParent();
            IFile outFile = folder.getFile((IPath)new Path(String.valueOf(f.getName().substring(0, f.getName().length() - f.getFileExtension().length() - 1)) + this.getTargetFileExtension()));
            if (outFile == null) {
                throw new ExecutionException("Unable to get file from folder");
            }
            String content = this.convert(outFile, f);
            if (!outFile.exists()) {
                try {
                    outFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    outFile.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), 3, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected abstract String convert(@NonNull IFile var1, @NonNull IFile var2) throws ExecutionException;

    protected abstract String getTargetFileExtension();
}

