/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fx.core.RankedService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class Util {
    private static Boolean isOSGi;
    private static Map<Class<?>, ServiceLoader<?>> LOADER_CACHE;

    static {
        LOADER_CACHE = new HashMap();
    }

    public static boolean isFX2() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("2");
    }

    public static @NonNull String notNull(@Nullable String value, @NonNull String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static boolean isOsgiEnv() {
        if (isOSGi == null) {
            isOSGi = Boolean.FALSE;
            try {
                Class.forName("org.osgi.framework.FrameworkUtil");
                if (FrameworkUtil.getBundle(Util.class) != null) {
                    isOSGi = Boolean.TRUE;
                }
            }
            catch (Throwable throwable) {}
        }
        return isOSGi;
    }

    private static BundleContext getContext(List<Class<?>> classList) {
        for (Class<?> cl : classList) {
            Bundle b = FrameworkUtil.getBundle(cl);
            BundleContext ctx = null;
            if (b == null || (ctx = b.getBundleContext()) == null) continue;
            return ctx;
        }
        Bundle b = FrameworkUtil.getBundle(Util.class);
        BundleContext ctx = null;
        if (b != null) {
            ctx = b.getBundleContext();
        }
        if (ctx == null) {
            throw new IllegalStateException("Unable to get a bundle context");
        }
        return ctx;
    }

    private static <S> @Nullable S _lookupService(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        List<@NonNull S> _lookupServiceList = Util._lookupServiceList(requestor, serviceClass);
        if (!_lookupServiceList.isEmpty()) {
            return _lookupServiceList.get(0);
        }
        return null;
    }

    private static <S> ServiceLoader<S> getLoader(Class<S> clazz) {
        ServiceLoader<Object> l = LOADER_CACHE.get(clazz);
        if (l == null) {
            l = ServiceLoader.load(clazz);
            LOADER_CACHE.put(clazz, l);
        }
        return l;
    }

    private static <S> @NonNull List<@NonNull S> _lookupServiceList(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        if (Util.isOsgiEnv()) {
            ArrayList cl = new ArrayList();
            if (requestor != null) {
                cl.add(requestor);
            }
            cl.add(serviceClass);
            BundleContext ctx = Util.getContext(cl);
            try {
                ServiceReference[] serviceReferences = ctx.getServiceReferences(serviceClass.getName(), null);
                if (serviceReferences == null) {
                    return Collections.emptyList();
                }
                return Stream.of(serviceReferences).map(r -> new CompareableService<Object>((ServiceReference<Object>)r, ctx.getService(r))).sorted().map(s -> s.instance).collect(Collectors.toList());
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        ServiceLoader<S> serviceLoader = Util.getLoader(serviceClass);
        Iterator<S> iterator = serviceLoader.iterator();
        ArrayList<S> rv = new ArrayList<S>();
        while (iterator.hasNext()) {
            rv.add(iterator.next());
        }
        Collections.sort(rv, (o1, o2) -> {
            if (o1 instanceof RankedService && o2 instanceof RankedService) {
                return -1 * Integer.compare(((RankedService)o1).getRanking(), ((RankedService)o2).getRanking());
            }
            return 0;
        });
        return rv;
    }

    public static <S> @Nullable S lookupService(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        return Util._lookupService(requestor, serviceClass);
    }

    public static <S> @Nullable S lookupService(@NonNull Class<S> serviceClass) {
        return Util._lookupService(null, serviceClass);
    }

    public static <S> @NonNull List<@NonNull S> lookupServiceList(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        return Util._lookupServiceList(requestor, serviceClass);
    }

    public static <S> @NonNull List<@NonNull S> lookupServiceList(@NonNull Class<S> serviceClass) {
        return Util._lookupServiceList(null, serviceClass);
    }

    static class CompareableService<@NonNull S>
    implements Comparable<CompareableService<S>> {
        private final ServiceReference<S> r;
        final S instance;

        public CompareableService(ServiceReference<S> r, S instance) {
            this.r = r;
            this.instance = instance;
        }

        private static int getRanking(ServiceReference<?> r) {
            Object v = r.getProperty("service.ranking");
            if (v instanceof Integer) {
                return (Integer)v;
            }
            return 0;
        }

        @Override
        public int compareTo(CompareableService<S> o) {
            int i2;
            int i1;
            if (this.instance instanceof RankedService && o.instance instanceof RankedService) {
                i1 = ((RankedService)this.instance).getRanking();
                i2 = ((RankedService)o.instance).getRanking();
            } else {
                i1 = CompareableService.getRanking(this.r);
                i2 = CompareableService.getRanking(o.r);
            }
            return -1 * Integer.compare(i1, i2);
        }
    }
}

