/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ide.css.cssDsl.ClassSelector;
import org.eclipse.fx.ide.css.cssDsl.CssSelector;
import org.eclipse.fx.ide.css.cssDsl.selector;
import org.eclipse.fx.ide.css.cssDsl.simple_selector;
import org.eclipse.fx.ide.css.cssext.ICSSExtModelProvider;
import org.eclipse.fx.ide.css.cssext.ICssExtManager;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRule;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleRef;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.Definition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.ElementDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PropertyDefinition;
import org.eclipse.fx.ide.css.cssext.proposal.CssExtProposalContributor;
import org.eclipse.fx.ide.css.cssext.ui.SearchHelper;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ICssResource;
import org.eclipse.fx.ide.css.extapi.Proposal;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CssExtManager
implements ICssExtManager {
    @Log(value="cssext.manager")
    private Logger logger;
    private List<CssExtProposalContributor> proposalContributors = new ArrayList<CssExtProposalContributor>();
    private List<ICSSExtModelProvider> extensionModelProvider = new ArrayList<ICSSExtModelProvider>();
    private boolean loaded = false;
    static int count = 0;

    public PropertyDefinition findPropertyByName(IFile f, EObject context, final String propertyName) {
        List<PropertyDefinition> search = new SearchHelper(this.collectModels(f, context)).findPropertiesByFilter(new SearchHelper.PropertyDefinitionFilter(){

            @Override
            public boolean returnOnFirstHit() {
                return true;
            }

            @Override
            public boolean filter(PropertyDefinition def) {
                return propertyName.equals(def.getName());
            }
        });
        if (search.isEmpty()) {
            return null;
        }
        return search.get(0);
    }

    public List<PropertyDefinition> findPropertiesBySelector(IFile f, EObject context, selector cssSelector) {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        this.logger.debug("searching for last selector");
        selector lastSelector = cssSelector;
        while (lastSelector.getSelector() != null) {
            lastSelector = lastSelector.getSelector();
        }
        this.logger.debug("lastSelector = " + lastSelector);
        for (simple_selector ss : lastSelector.getSimpleselectors()) {
            String elementName = null;
            new ArrayList();
            if (ss.getElement() != null) {
                this.logger.debug(" - found element selector: " + ss.getElement().getName());
                elementName = ss.getElement().getName();
            }
            HashSet<String> styleClasses = new HashSet<String>();
            for (CssSelector subs : ss.getSubSelectors()) {
                if (!(subs instanceof ClassSelector)) continue;
                this.logger.debug(" - found class selector: ." + ((ClassSelector)subs).getName());
                styleClasses.add(((ClassSelector)subs).getName());
            }
            final String finalElementName = elementName;
            final HashSet<String> finalStyleClasses = styleClasses;
            LinkedList<ElementDefinition> superElements = new LinkedList<ElementDefinition>();
            superElements.addAll(new SearchHelper(this.collectModels(f, context)).findObjects(new SearchHelper.SearchFilter<ElementDefinition>(){

                @Override
                public Class<ElementDefinition> getSearchClass() {
                    return ElementDefinition.class;
                }

                @Override
                public boolean filter(ElementDefinition obj) {
                    if (obj.getName().equals(finalElementName)) {
                        CssExtManager.this.logger.debug("found by name -> " + obj);
                        return true;
                    }
                    if (finalStyleClasses.contains(obj.getStyleclass())) {
                        CssExtManager.this.logger.debug("found by styleclass -> " + obj);
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean returnOnFirstHit() {
                    return false;
                }
            }));
            HashSet<ElementDefinition> allElements = new HashSet<ElementDefinition>();
            while (!superElements.isEmpty()) {
                ElementDefinition cur = (ElementDefinition)superElements.poll();
                if (cur.getSuper() != null && !cur.getSuper().isEmpty()) {
                    superElements.addAll((Collection<ElementDefinition>)cur.getSuper());
                }
                allElements.add(cur);
            }
            for (ElementDefinition d : allElements) {
                for (Definition def : d.getProperties()) {
                    result.add((PropertyDefinition)def);
                }
            }
        }
        this.logger.debug("findPropertiesBySelector found " + result.size() + " properties");
        return result;
    }

    public List<PropertyDefinition> findAllProperties(IFile f, EObject context) {
        List<PropertyDefinition> defs = new SearchHelper(this.collectModels(f, context)).findPropertiesByFilter(new SearchHelper.PropertyDefinitionFilter(){

            @Override
            public boolean returnOnFirstHit() {
                return false;
            }

            @Override
            public boolean filter(PropertyDefinition def) {
                return true;
            }
        });
        return defs;
    }

    public ElementDefinition findElementByName(IFile f, EObject context, final String elName) {
        List<ElementDefinition> search = new SearchHelper(this.collectModels(f, context)).findObjects(new SearchHelper.SearchFilter<ElementDefinition>(){

            @Override
            public Class<ElementDefinition> getSearchClass() {
                return ElementDefinition.class;
            }

            @Override
            public boolean returnOnFirstHit() {
                return true;
            }

            @Override
            public boolean filter(ElementDefinition def) {
                return elName.equals(def.getName());
            }
        });
        if (search.isEmpty()) {
            return null;
        }
        return search.get(0);
    }

    public ElementDefinition findElementByStyleClass(IFile f, EObject context, final String styleClass) {
        List<ElementDefinition> r = new SearchHelper(this.collectModels(f, context)).findObjects(new SearchHelper.SearchFilter<ElementDefinition>(){

            @Override
            public Class<ElementDefinition> getSearchClass() {
                return ElementDefinition.class;
            }

            @Override
            public boolean filter(ElementDefinition obj) {
                return obj.getStyleclass() != null && obj.getStyleclass().equals(styleClass);
            }

            @Override
            public boolean returnOnFirstHit() {
                return true;
            }
        });
        if (!r.isEmpty()) {
            return r.get(0);
        }
        return null;
    }

    public IJavaProject getJavaprojectFromPlatformURI(URI uri) {
        String projectName = null;
        if (uri.isPlatform()) {
            projectName = uri.segment(1);
        }
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return JavaCore.create((IProject)p);
    }

    public void searchClasspath(URI uri) {
        IJavaProject project = this.getJavaprojectFromPlatformURI(uri);
        try {
            IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                switch (entry.getEntryKind()) {
                    default: 
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public CSSRule resolveReference(IFile f, EObject context, CSSRuleRef ref) {
        Definition definition = ref.getRef();
        CSSRule result = definition.getRule();
        if (result == null && definition instanceof CSSRuleDefinition) {
            result = ((CSSRuleDefinition)definition).getFunc();
        }
        return result;
    }

    public void addCssExtProposalContributer(CssExtProposalContributor c) {
        this.proposalContributors.add(c);
    }

    public void removeCssExtProposalContributer(CssExtProposalContributor c) {
        this.proposalContributors.remove(c);
    }

    public List<Proposal> getContributedProposalsForRule(IFile f, String fqRuleName) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        for (CssExtProposalContributor c : this.proposalContributors) {
            if (!fqRuleName.equals(c.getRule())) continue;
            result.add(c.getProposal());
            this.logger.debug("found " + c.getProposal() + " for " + fqRuleName);
        }
        return result;
    }

    public void addCssExtensionModelProvider(ICSSExtModelProvider p) {
        this.extensionModelProvider.add(p);
    }

    public void removeCssExtensionModelProvider(ICSSExtModelProvider p) {
        this.extensionModelProvider.remove(p);
    }

    private Set<CssExtension> collectModels(IFile file, EObject context) {
        ICssResource cssFile = (ICssResource)Platform.getAdapterManager().getAdapter((Object)file, ICssResource.class);
        if (cssFile != null) {
            this.logger.debug("USING extensions from cssFile");
            return cssFile.getEnabledCssExtensions(context);
        }
        this.logger.debug("defaulting to old provider");
        HashSet<CssExtension> rv = new HashSet<CssExtension>();
        for (ICSSExtModelProvider p : this.extensionModelProvider) {
            rv.addAll(p.getModels(file));
        }
        return rv;
    }
}

