/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.mobile.sim.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.fx.ide.ui.mobile.sim.launch.DeviceType;
import org.eclipse.fx.ide.ui.mobile.sim.launch.Orientation;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MainTab
extends AbstractLaunchConfigurationTab {
    private ComboViewer deviceType;
    private ComboViewer deviceOrientation;
    private Text width;
    private Text height;
    private Text mobileApp;

    static {
        JFaceResources.getImageRegistry().put("SimTabImage", new Image((Device)Display.getCurrent(), MainTab.class.getClassLoader().getResourceAsStream("/icons/images.png")));
    }

    public Image getImage() {
        return JFaceResources.getImage((String)"SimTabImage");
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout());
        Group g = new Group(parent, 0);
        g.setText("Mobile Application");
        g.setLayout((Layout)new GridLayout(2, false));
        g.setLayoutData((Object)new GridData(768));
        this.mobileApp = new Text((Composite)g, 2048);
        this.mobileApp.setLayoutData((Object)new GridData(768));
        this.mobileApp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button b = new Button((Composite)g, 8);
        b.setText("Browse...");
        g = new Group(parent, 0);
        g.setText("Simulator configuration");
        g.setLayout((Layout)new GridLayout(4, false));
        g.setLayoutData((Object)new GridData(768));
        Label l = new Label((Composite)g, 0);
        l.setText("Device Type:");
        this.deviceType = new ComboViewer((Composite)g, 8);
        this.deviceType.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.deviceType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.deviceType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                switch ((DeviceType)((Object)element)) {
                    case ANDROID_PHONE: {
                        return "Android Phone";
                    }
                    case ANDROID_TABLET: {
                        return "Android Tablet";
                    }
                    case IPAD: {
                        return "iPad";
                    }
                }
                return "iPhone";
            }
        });
        this.deviceType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.deviceType.setInput((Object)DeviceType.values());
        l = new Label((Composite)g, 0);
        l.setText("Device Orientation:");
        this.deviceOrientation = new ComboViewer((Composite)g, 8);
        this.deviceOrientation.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.deviceOrientation.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.deviceOrientation.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == Orientation.HORIZONTAL ? "horizontal" : "vertical";
            }
        });
        this.deviceOrientation.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.deviceOrientation.setInput((Object)Orientation.values());
        l = new Label((Composite)g, 0);
        l.setText("Display size:");
        this.width = new Text((Composite)g, 2048);
        this.width.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label((Composite)g, 0).setText("x");
        this.height = new Text((Composite)g, 2048);
        this.height.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_TYPE", DeviceType.IPHONE.name());
        configuration.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_ORIENTATION", Orientation.VERTICAL.name());
        configuration.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", "640x1136");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.deviceType.setSelection((ISelection)new StructuredSelection((Object)DeviceType.valueOf(configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_TYPE", DeviceType.IPHONE.name()))));
            this.deviceOrientation.setSelection((ISelection)new StructuredSelection((Object)Orientation.valueOf(configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_ORIENTATION", Orientation.VERTICAL.name()))));
            this.width.setText(configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", "640x1136").substring(0, configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", "640x1136").indexOf(120)));
            this.height.setText(configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", "640x1136").substring(configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", "640x1136").indexOf(120) + 1));
            this.mobileApp.setText(configuration.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.APP_CLASS", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_TYPE", ((DeviceType)((Object)((IStructuredSelection)this.deviceType.getSelection()).getFirstElement())).name());
        configuration.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_ORIENTATION", ((Orientation)((Object)((IStructuredSelection)this.deviceOrientation.getSelection()).getFirstElement())).name());
        configuration.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", String.valueOf(this.width.getText()) + "x" + this.height.getText());
        configuration.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.APP_CLASS", this.mobileApp.getText());
    }

    public String getName() {
        return "Simulator";
    }
}

