/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.command.Command;
import org.eclipse.fx.core.di.Service;
import org.eclipse.fx.core.observable.FXObservableUtil;
import org.eclipse.fx.ui.controls.list.SimpleListCell;
import org.eclipse.fx.ui.preferences.PreferencePage;
import org.eclipse.fx.ui.preferences.PreferencePageFactory;
import org.eclipse.fx.ui.preferences.PreferencePageProvider;

public class PreferenceUI {
    public static final String TOP_LEVEL_STYLE = "preferences-container";
    public static final String CONTENT_AREA_STYLE = "preferences-contents";
    public static final String PAGE_STYLE = "preferences-page";
    public static final String PAGE_LIST_STYLE = "preferences-page-list";
    public static final String SEARCH_STYLE = "preferences-search-field";
    public static final String ACTIONS_BAR_STYLE = "preferences-actions-bar";
    private final ListView<PreferencePageProvider> providerView;
    private final TitledPane contentAreaWrapper;
    private final ScrollPane contentArea;
    private final List<Consumer<PreferencePage>> onCancelHandlers = new ArrayList<Consumer<PreferencePage>>();
    private final List<Consumer<PreferencePage>> onOkHandlers = new ArrayList<Consumer<PreferencePage>>();
    private Map<PreferencePageProvider, PageCache> pages = new HashMap<PreferencePageProvider, PageCache>();
    private final PreferencePageFactory factory;
    protected String currentFilterTerm = "";
    private Comparator<PreferencePageProvider> comparator;
    private Predicate<PreferencePageProvider> filter;
    private final ObservableList<PreferencePageProvider> providers = FXCollections.observableArrayList();
    private final SortedList<PreferencePageProvider> sortedProviders;
    private final FilteredList<PreferencePageProvider> filteredProviders;
    private PageCache currentPage;
    private HBox actions;
    private TextField searchField;

    @Inject
    public PreferenceUI(PreferencePageFactory factory) {
        this.factory = factory;
        this.providerView = new ListView();
        this.providerView.getStyleClass().add((Object)PAGE_LIST_STYLE);
        this.contentAreaWrapper = new TitledPane();
        this.contentArea = new ScrollPane();
        this.contentArea.setFitToWidth(true);
        this.contentArea.setFitToHeight(true);
        this.contentAreaWrapper.setContent((Node)this.contentArea);
        this.contentAreaWrapper.setMaxHeight(Double.MAX_VALUE);
        this.contentAreaWrapper.setMaxWidth(Double.MAX_VALUE);
        this.contentAreaWrapper.setCollapsible(false);
        this.filter = this.createFilter();
        this.comparator = this.createComparator();
        this.sortedProviders = this.providers.sorted(this.comparator);
        this.filteredProviders = this.sortedProviders.filtered(this.filter);
        this.providerView.setCellFactory(v -> new SimpleListCell(pp -> (CharSequence)pp.titleProperty().getValue()));
        FXObservableUtil.onChange((ObservableValue)this.providerView.getSelectionModel().selectedItemProperty(), this::handleSelectedPageChange);
        this.providerView.setItems(this.filteredProviders);
    }

    protected Predicate<PreferencePageProvider> createFilter() {
        return provider -> {
            String term = this.currentFilterTerm == null ? "*" : "*" + this.currentFilterTerm + "*";
            return provider.select(term);
        };
    }

    protected Comparator<PreferencePageProvider> createComparator() {
        return (p1, p2) -> Collator.getInstance().compare(((CharSequence)p1.titleProperty().getValue()).toString(), ((CharSequence)p2.titleProperty().getValue()).toString());
    }

    private void handleSelectedPageChange(PreferencePageProvider provider) {
        if (provider != null) {
            this.currentPage = this.pages.computeIfAbsent(provider, p -> {
                BorderPane parent = new BorderPane();
                parent.getStyleClass().add((Object)PAGE_STYLE);
                return new PageCache(this.factory.make(parent, provider), parent);
            });
            this.contentAreaWrapper.setText(((CharSequence)provider.titleProperty().getValue()).toString());
            this.contentArea.setContent((Node)this.currentPage.parent);
        } else {
            this.contentArea.setContent(null);
            this.contentAreaWrapper.setText(null);
            this.currentPage = null;
        }
    }

    @PostConstruct
    void init(BorderPane container) {
        BorderPane root = new BorderPane(){

            public String getUserAgentStylesheet() {
                return "platform:/plugin/org.eclipse.fx.ui.preferences/preferenceUI.css";
            }
        };
        root.getStyleClass().add((Object)TOP_LEVEL_STYLE);
        container.setCenter((Node)root);
        SplitPane split = new SplitPane();
        VBox box = new VBox();
        this.searchField = new TextField();
        this.searchField.getStyleClass().add((Object)SEARCH_STYLE);
        FXObservableUtil.onChange((ObservableValue)this.searchField.textProperty(), newFilter -> {
            this.currentFilterTerm = newFilter == null ? "" : newFilter;
            this.refreshFilter();
        });
        box.getChildren().add((Object)this.searchField);
        box.getChildren().add(this.providerView);
        VBox.setVgrow(this.providerView, (Priority)Priority.ALWAYS);
        split.getItems().add((Object)box);
        SplitPane.setResizableWithParent((Node)box, (Boolean)false);
        BorderPane p = new BorderPane();
        p.getStyleClass().add((Object)CONTENT_AREA_STYLE);
        p.setCenter((Node)this.contentAreaWrapper);
        split.getItems().add((Object)p);
        split.setDividerPositions(new double[]{0.3});
        root.setCenter((Node)split);
        this.actions = new HBox();
        this.actions.getStyleClass().add((Object)ACTIONS_BAR_STYLE);
        this.actions.setMinWidth(Double.NEGATIVE_INFINITY);
        this.actions.setAlignment(Pos.BASELINE_RIGHT);
        this.createActionButtons();
        root.setBottom((Node)this.actions);
        this.selectFirstPage();
    }

    protected void createActionButtons() {
        this.addButton("Cancel", this.cancel());
        this.addButton("Apply and Close", this.applyAndClose());
    }

    private Optional<Command<Void>> applyAndClose() {
        return Optional.of(Command.createCommand(() -> {
            for (PageCache pageCache : this.pages.values()) {
                Command<Void> persist = pageCache.page.persist();
                persist.evaluate();
                if (!persist.isEnabled()) continue;
                persist.execute();
            }
            PreferencePage activePreferencePage = this.currentPage == null ? null : this.currentPage.page;
            this.onOkHandlers.forEach(handler -> handler.accept(activePreferencePage));
        }));
    }

    private Optional<Command<Void>> cancel() {
        return Optional.of(Command.createCommand(() -> {
            for (PageCache pageCache : this.pages.values()) {
                pageCache.page.reset().execute();
            }
            PreferencePage activePreferencePage = this.currentPage == null ? null : this.currentPage.page;
            this.onCancelHandlers.forEach(handler -> handler.accept(activePreferencePage));
        }));
    }

    protected void addButton(String label, Optional<Command<Void>> restoreDefault) {
        Button action = new Button(label);
        this.actions.getChildren().add((Object)action);
        if (restoreDefault.isPresent()) {
            Command<Void> command = restoreDefault.get();
            action.disableProperty().bind((ObservableValue)command.enabledProperty().not());
            action.setOnAction(event -> {
                command.evaluate();
                if (command.isEnabled()) {
                    command.execute();
                }
            });
        } else {
            action.setDisable(true);
        }
    }

    private void refreshFilter() {
        MultipleSelectionModel selectionModel = this.providerView.getSelectionModel();
        PreferencePageProvider selectedItem = (PreferencePageProvider)selectionModel.getSelectedItem();
        this.filteredProviders.predicateProperty().set(null);
        this.filteredProviders.predicateProperty().set(this.filter);
        if (selectionModel.isEmpty()) {
            if (selectedItem == null || !this.filteredProviders.contains((Object)selectedItem)) {
                selectionModel.selectFirst();
            } else {
                selectionModel.select((Object)selectedItem);
            }
        }
    }

    private void selectFirstPage() {
        this.providerView.getSelectionModel().clearSelection();
        this.providerView.getSelectionModel().selectFirst();
    }

    @Inject
    public void setPreferencePageProviders(@Service List<PreferencePageProvider> providers) {
        this.providers.setAll(providers);
    }

    public Subscription registerOnCancelHandler(Consumer<PreferencePage> handler) {
        this.onCancelHandlers.add(handler);
        return () -> {
            boolean bl = this.onCancelHandlers.remove(handler);
        };
    }

    public Subscription registerOnOkHandler(Consumer<PreferencePage> handler) {
        this.onOkHandlers.add(handler);
        return () -> {
            boolean bl = this.onOkHandlers.remove(handler);
        };
    }

    public void setFilter(String filter) {
        this.searchField.setText(filter);
    }

    public void selectPage(String pageId) {
        if (pageId == null) {
            return;
        }
        this.providers.stream().filter(p -> pageId.equals(p.id())).findAny().ifPresent(arg_0 -> ((MultipleSelectionModel)this.providerView.getSelectionModel()).select(arg_0));
    }

    static class PageCache {
        final PreferencePage page;
        final BorderPane parent;

        public PageCache(PreferencePage page, BorderPane parent) {
            this.page = page;
            this.parent = parent;
        }
    }
}

