/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Text_anchor implements Enumerator
{
    START(0, "start", "start"),
    MIDDLE(1, "middle", "middle"),
    END(2, "end", "end"),
    INHERIT(3, "inherit", "inherit");

    public static final int START_VALUE = 0;
    public static final int MIDDLE_VALUE = 1;
    public static final int END_VALUE = 2;
    public static final int INHERIT_VALUE = 3;
    private static final Text_anchor[] VALUES_ARRAY;
    public static final List<Text_anchor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Text_anchor[]{START, MIDDLE, END, INHERIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Text_anchor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Text_anchor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Text_anchor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Text_anchor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Text_anchor get(int value) {
        switch (value) {
            case 0: {
                return START;
            }
            case 1: {
                return MIDDLE;
            }
            case 2: {
                return END;
            }
            case 3: {
                return INHERIT;
            }
        }
        return null;
    }

    private Text_anchor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

