/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.registration;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.registration.Registration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.runtime.dto.ListenerDTO;

public class ListenerRegistration
extends Registration<EventListener, ListenerDTO> {
    private final ContextController.ServiceHolder<EventListener> listenerHolder;
    private final List<Class<? extends EventListener>> classes;
    private final EventListener proxy;
    private final ServletContext servletContext;
    private final ContextController contextController;
    private final ClassLoader classLoader;

    public ListenerRegistration(ContextController.ServiceHolder<EventListener> listenerHolder, List<Class<? extends EventListener>> classes, ListenerDTO listenerDTO, ServletContext servletContext, ContextController contextController) {
        super(listenerHolder.get(), listenerDTO);
        this.listenerHolder = listenerHolder;
        this.classes = classes;
        this.servletContext = servletContext;
        this.contextController = contextController;
        this.classLoader = ((BundleWiring)listenerHolder.getBundle().adapt(BundleWiring.class)).getClassLoader();
        this.createContextAttributes();
        this.proxy = (EventListener)Proxy.newProxyInstance(this.getClass().getClassLoader(), classes.toArray(new Class[0]), (InvocationHandler)new EventListenerInvocationHandler());
    }

    @Override
    public synchronized void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.contextController.getListenerRegistrations().remove(this);
            this.contextController.getEventListeners().remove(this.classes, this);
            this.contextController.ungetServletContextHelper(this.listenerHolder.getBundle());
            super.destroy();
            if (this.classes.contains(ServletContextListener.class)) {
                ServletContextListener servletContextListener = (ServletContextListener)super.getT();
                servletContextListener.contextDestroyed(new ServletContextEvent(this.servletContext));
            }
        }
        finally {
            this.destroyContextAttributes();
            Thread.currentThread().setContextClassLoader(original);
            this.listenerHolder.release();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListenerRegistration)) {
            return false;
        }
        ListenerRegistration listenerRegistration = (ListenerRegistration)obj;
        return ((EventListener)super.getT()).equals(listenerRegistration.getT());
    }

    public int hashCode() {
        return Long.valueOf(((ListenerDTO)this.getD()).serviceId).hashCode();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public EventListener getT() {
        return this.proxy;
    }

    private void createContextAttributes() {
        this.contextController.getProxyContext().createContextAttributes(this.contextController);
    }

    private void destroyContextAttributes() {
        this.contextController.getProxyContext().destroyContextAttributes(this.contextController);
    }

    private class EventListenerInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ListenerRegistration.this.classLoader);
                try {
                    Object object = method.invoke(ListenerRegistration.super.getT(), args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }
}

