/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.internal.databinding.observable.Util;

public abstract class MapDiff
implements IDiff {
    public boolean isEmpty() {
        return this.getAddedKeys().isEmpty() && this.getRemovedKeys().isEmpty() && this.getChangedKeys().isEmpty();
    }

    public void applyTo(Map map) {
        for (Object key : this.getAddedKeys()) {
            map.put(key, this.getNewValue(key));
        }
        for (Object key : this.getChangedKeys()) {
            map.put(key, this.getNewValue(key));
        }
        Iterator it = this.getRemovedKeys().iterator();
        while (it.hasNext()) {
            map.remove(it.next());
        }
    }

    public Map simulateOn(Map map) {
        return new DeltaMap(map, this);
    }

    public abstract Set getAddedKeys();

    public abstract Set getRemovedKeys();

    public abstract Set getChangedKeys();

    public abstract Object getOldValue(Object var1);

    public abstract Object getNewValue(Object var1);

    private static abstract class AbstractMapEntry
    implements Map.Entry {
        private AbstractMapEntry() {
        }

        public Object setValue(Object arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)obj;
            return Util.equals(this.getKey(), that.getKey()) && Util.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            Object key = this.getKey();
            Object value = this.getValue();
            return this.hash(key) ^ this.hash(value);
        }

        private int hash(Object key) {
            return key == null ? 0 : key.hashCode();
        }
    }

    private static class DeltaMap
    extends AbstractMap {
        private final Map map;
        private final MapDiff diff;
        private Set entrySet;

        public DeltaMap(Map map, MapDiff diff) {
            this.map = map;
            this.diff = diff;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.diff.getAddedKeys().contains(key) || this.map.containsKey(key) && !this.diff.getRemovedKeys().contains(key);
        }

        @Override
        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new DeltaMapEntrySet(this.map, this.diff);
            }
            return this.entrySet;
        }

        @Override
        public Object get(Object key) {
            if (this.diff.getAddedKeys().contains(key)) {
                return this.diff.getNewValue(key);
            }
            if (this.diff.getChangedKeys().contains(key)) {
                return this.diff.getNewValue(key);
            }
            if (this.diff.getRemovedKeys().contains(key)) {
                return null;
            }
            return this.map.get(key);
        }

        @Override
        public Object put(Object arg0, Object arg1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DeltaMapEntry
    extends AbstractMapEntry {
        private final Object key;
        private final MapDiff diff;

        public DeltaMapEntry(Object key, MapDiff diff) {
            this.key = key;
            this.diff = diff;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.diff.getNewValue(this.key);
        }
    }

    private static class DeltaMapEntrySet
    extends AbstractSet {
        private final Map map;
        private final MapDiff diff;

        public DeltaMapEntrySet(Map map, MapDiff diff) {
            this.map = map;
            this.diff = diff;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator origEntries;
                Iterator addedKeys;
                boolean haveNext;
                Map.Entry next;
                {
                    this.origEntries = DeltaMapEntrySet.this.map.entrySet().iterator();
                    this.addedKeys = DeltaMapEntrySet.this.diff.getAddedKeys().iterator();
                    this.haveNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                public Object next() {
                    if (!this.findNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry myNext = this.next;
                    this.haveNext = false;
                    this.next = null;
                    return myNext;
                }

                private boolean findNext() {
                    Map.Entry candidateEntry;
                    block4: {
                        Object candidateKey;
                        if (this.haveNext) {
                            return true;
                        }
                        while (this.origEntries.hasNext()) {
                            candidateEntry = (Map.Entry)this.origEntries.next();
                            candidateKey = candidateEntry.getKey();
                            if (DeltaMapEntrySet.this.diff.getRemovedKeys().contains(candidateKey)) continue;
                            candidateEntry = DeltaMapEntrySet.this.diff.getChangedKeys().contains(candidateKey) ? new DeltaMapEntry(candidateKey, DeltaMapEntrySet.this.diff) : new MapEntryWrapper(candidateEntry);
                            break block4;
                        }
                        if (this.addedKeys.hasNext()) {
                            candidateKey = this.addedKeys.next();
                            candidateEntry = new DeltaMapEntry(candidateKey, DeltaMapEntrySet.this.diff);
                        } else {
                            return false;
                        }
                    }
                    this.haveNext = true;
                    this.next = candidateEntry;
                    return true;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.map.size() + this.diff.getAddedKeys().size() - this.diff.getRemovedKeys().size();
        }
    }

    private static class MapEntryWrapper
    extends AbstractMapEntry {
        private final Map.Entry entry;

        public MapEntryWrapper(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }
    }
}

