/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimePlatform;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenPackageGeneratorAdapter
extends GenBaseGeneratorAdapter {
    protected static final int PACKAGE_CLASS_ID = 0;
    protected static final int FACTORY_CLASS_ID = 1;
    protected static final int XML_PROCESSOR_CLASS_ID = 2;
    protected static final int VALIDATOR_CLASS_ID = 3;
    protected static final int SWITCH_CLASS_ID = 4;
    protected static final int ADAPTER_FACTORY_CLASS_ID = 5;
    protected static final int RESOURCE_FACTORY_CLASS_ID = 6;
    protected static final int RESOURCE_CLASS_ID = 7;
    protected static final int ITEM_PROVIDER_ADAPTER_FACTORY_ID = 8;
    protected static final int EDITOR_ID = 9;
    protected static final int MODEL_WIZARD_ID = 10;
    protected static final int ACTION_BAR_CONTRIBUTOR_ID = 11;
    protected static final int PACKAGE_TEST_SUITE_ID = 12;
    protected static final int PACKAGE_EXAMPLE_ID = 13;
    private static final AbstractGeneratorAdapter.JETEmitterDescriptor[] JET_EMITTER_DESCRIPTORS = new AbstractGeneratorAdapter.JETEmitterDescriptor[]{new AbstractGeneratorAdapter.JETEmitterDescriptor("model/PackageClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.PackageClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/FactoryClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.FactoryClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/XMLProcessorClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.XMLProcessorClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/ValidatorClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.ValidatorClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/SwitchClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.SwitchClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/AdapterFactoryClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.AdapterFactoryClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/ResourceFactoryClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.ResourceFactoryClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/ResourceClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.ResourceClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("edit/ItemProviderAdapterFactory.javajet", "org.eclipse.emf.codegen.ecore.templates.edit.ItemProviderAdapterFactory"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/Editor.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.Editor"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/ModelWizard.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.ModelWizard"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/ActionBarContributor.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.ActionBarContributor"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model.tests/PackageTestSuite.javajet", "org.eclipse.emf.codegen.ecore.templates.model.tests.PackageTestSuite"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model.tests/PackageExample.javajet", "org.eclipse.emf.codegen.ecore.templates.model.tests.PackageExample")};
    protected static final int MODEL_ICON_ID = 0;
    protected static final int MODEL_WIZARD_ICON_ID = 1;
    protected static final int CREATE_CHILD_ICON_ID = 2;
    private static final String[] INPUT_PATH_NAMES = new String[]{"editor/ModelFile.gif", "editor/NewModel.gif", "edit/CreateChild.gif"};

    protected AbstractGeneratorAdapter.JETEmitterDescriptor[] getJETEmitterDescriptors() {
        return JET_EMITTER_DESCRIPTORS;
    }

    protected String[] getInputPathNames() {
        return INPUT_PATH_NAMES;
    }

    public GenPackageGeneratorAdapter(GeneratorAdapterFactory generatorAdapterFactory) {
        super(generatorAdapterFactory);
    }

    @Override
    protected Collection<?> getGenerateModelChildren(Object object) {
        GenPackage genPackage = (GenPackage)object;
        ArrayList<GenClass> result = new ArrayList<GenClass>((Collection<GenClass>)genPackage.getGenClasses());
        result.addAll((Collection<GenClass>)genPackage.getGenEnums());
        result.addAll((Collection<GenClass>)genPackage.getNestedGenPackages());
        return result;
    }

    @Override
    protected Collection<?> getGenerateEditChildren(Object object) {
        GenPackage genPackage = (GenPackage)object;
        ArrayList<GenClass> result = new ArrayList<GenClass>((Collection<GenClass>)genPackage.getGenClasses());
        result.addAll((Collection<GenClass>)genPackage.getNestedGenPackages());
        return result;
    }

    @Override
    protected Collection<?> getGenerateEditorChildren(Object object) {
        return new ArrayList<GenPackage>((Collection<GenPackage>)((GenPackage)object).getNestedGenPackages());
    }

    @Override
    protected Collection<?> getGenerateTestsChildren(Object object) {
        GenPackage genPackage = (GenPackage)object;
        ArrayList<GenClass> result = new ArrayList<GenClass>((Collection<GenClass>)genPackage.getGenClasses());
        result.addAll((Collection<GenClass>)genPackage.getNestedGenPackages());
        return result;
    }

    @Override
    public Object getGenerateParent(Object object, Object projectType) {
        return this.getParent(object);
    }

    @Override
    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject".equals(projectType)) {
            ((GenPackage)object).prepareCache();
            return Diagnostic.OK_INSTANCE;
        }
        return super.doPreGenerate(object, projectType);
    }

    @Override
    protected Diagnostic doPostGenerate(Object object, Object projectType) {
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject".equals(projectType)) {
            ((GenPackage)object).clearCache();
            return Diagnostic.OK_INSTANCE;
        }
        return super.doPostGenerate(object, projectType);
    }

    @Override
    protected Diagnostic generateModel(Object object, Monitor monitor) {
        monitor.beginTask("", 13);
        GenPackage genPackage = (GenPackage)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingPackage_message", new Object[]{genPackage.getBasicPackageName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getModelDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateSchema(genPackage, monitor);
        this.generatePackagePublication(genPackage, monitor);
        this.generatePackageSerialization(genPackage, monitor);
        this.generatePackageInterface(genPackage, monitor);
        this.generatePackageClass(genPackage, monitor);
        this.generateFactoryInterface(genPackage, monitor);
        this.generateFactoryClass(genPackage, monitor);
        this.generateXMLProcessorClass(genPackage, monitor);
        this.generateValidatorClass(genPackage, monitor);
        this.generateSwitchClass(genPackage, monitor);
        this.generateAdapterFactoryClass(genPackage, monitor);
        this.generateResourceFactoryClass(genPackage, monitor);
        this.generateResourceClass(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateSchema(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.getGenModel().isGenerateSchema()) {
            genPackage.generateSchema();
        }
        monitor.worked(1);
    }

    protected void generatePackagePublication(GenPackage genPackage, Monitor monitor) {
        String publicationLocation = genPackage.getPublicationLocation();
        if (publicationLocation != null && !"".equals(publicationLocation)) {
            monitor = this.createMonitor(monitor, 1);
            try {
                monitor.beginTask("", 2);
                GenModel genModel = genPackage.getGenModel();
                this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingPackageSerialization_message", new Object[]{publicationLocation});
                monitor.subTask(this.message);
                URI targetFile = this.toURI(publicationLocation);
                this.ensureContainerExists(targetFile.trimSegments(1), this.createMonitor(monitor, 1));
                final ResourceSet originalSet = genModel.eResource().getResourceSet();
                EPackage originalPackage = genPackage.getEcorePackage();
                ResourceSetImpl outputSet = new ResourceSetImpl();
                outputSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
                URI targetURI = this.toPlatformResourceURI(targetFile);
                Resource outputResource = outputSet.createResource(targetURI);
                EPackage outputPackage = (EPackage)EcoreUtil.copy((EObject)originalPackage);
                outputResource.getContents().add((Object)outputPackage);
                URIHandlerImpl.PlatformSchemeAware uriHandler = new URIHandlerImpl.PlatformSchemeAware(){

                    private EPackage getRootContainingPackage(EObject object) {
                        EPackage result = null;
                        while (object != null) {
                            if (object instanceof EPackage) {
                                result = (EPackage)object;
                            }
                            object = object.eContainer();
                        }
                        return result;
                    }

                    private EPackage getContainingPackage(EObject object) {
                        while (object != null) {
                            if (object instanceof EPackage) {
                                return (EPackage)object;
                            }
                            object = object.eContainer();
                        }
                        return null;
                    }

                    private URI redirect(URI uri) {
                        if (uri.hasFragment()) {
                            EPackage ePackage;
                            if (uri.trimFragment().equals(this.baseURI)) {
                                return super.deresolve(uri);
                            }
                            EObject object = originalSet.getEObject(uri, false);
                            if (object != null && (ePackage = this.getRootContainingPackage(object)) != null) {
                                String schemaLocation = EcoreUtil.getAnnotation((EModelElement)ePackage, (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"schemaLocation");
                                if (schemaLocation != null) {
                                    return URI.createURI((String)schemaLocation).appendFragment(uri.fragment());
                                }
                                String relativeURIFragmentPath = EcoreUtil.getRelativeURIFragmentPath((EObject)this.getContainingPackage(object), (EObject)object);
                                return URI.createURI((String)ePackage.getNsURI()).appendFragment("//" + relativeURIFragmentPath);
                            }
                        }
                        return uri;
                    }

                    public URI deresolve(URI uri) {
                        return this.redirect(uri);
                    }

                    public URI resolve(URI uri) {
                        throw new UnsupportedOperationException("There should be no resolving while serializing");
                    }
                };
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("URI_HANDLER", uriHandler);
                options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                options.put("LINE_DELIMITER", "");
                try {
                    outputResource.save(options);
                }
                catch (IOException exception) {
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
            finally {
                monitor.done();
            }
        } else {
            monitor.worked(1);
        }
    }

    protected void generatePackageSerialization(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isLoadingInitialization()) {
            monitor = this.createMonitor(monitor, 1);
            try {
                monitor.beginTask("", 2);
                final GenModel genModel = genPackage.getGenModel();
                String targetPathName = String.valueOf(genModel.getModelDirectory()) + "/" + genPackage.getClassPackageName().replace('.', '/') + "/" + genPackage.getSerializedPackageFilename();
                this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingPackageSerialization_message", new Object[]{targetPathName});
                monitor.subTask(this.message);
                URI targetFile = this.toURI(targetPathName);
                this.ensureContainerExists(targetFile.trimSegments(1), this.createMonitor(monitor, 1));
                final ResourceSet originalSet = genModel.eResource().getResourceSet();
                EPackage originalPackage = genPackage.getEcorePackage();
                ResourceSetImpl outputSet = new ResourceSetImpl();
                outputSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
                URI targetURI = this.toPlatformResourceURI(targetFile);
                Resource outputResource = outputSet.createResource(targetURI);
                EcoreUtil.Copier copier = new EcoreUtil.Copier(){
                    private static final long serialVersionUID = 1L;

                    protected void copyContainment(EReference reference, EObject object, EObject copyEObject) {
                        if (reference == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS) {
                            EList result = ((EModelElement)copyEObject).getEAnnotations();
                            result.clear();
                            for (EAnnotation eAnnotation : ((EModelElement)object).getEAnnotations()) {
                                if (genModel.isSuppressedAnnotation(eAnnotation.getSource())) continue;
                                result.add((EAnnotation)this.copy((EObject)eAnnotation));
                            }
                            return;
                        }
                        super.copyContainment(reference, object, copyEObject);
                    }
                };
                EPackage outputPackage = (EPackage)copier.copy((EObject)originalPackage);
                copier.copyReferences();
                outputResource.getContents().add((Object)outputPackage);
                this.collapseEmptyPackages(outputPackage);
                URIHandlerImpl.PlatformSchemeAware uriHandler = new URIHandlerImpl.PlatformSchemeAware(){

                    private EPackage getContainingPackage(EObject object) {
                        while (object != null) {
                            if (object instanceof EPackage) {
                                return (EPackage)object;
                            }
                            object = object.eContainer();
                        }
                        return null;
                    }

                    private String getRelativeFragmentPath(Resource resource, EObject base, String path) {
                        String basePath = resource.getURIFragment(base);
                        if (basePath != null && path.startsWith(basePath)) {
                            int i = basePath.length();
                            if (path.length() == i) {
                                return "";
                            }
                            if (path.charAt(i) == '/') {
                                return path.substring(i);
                            }
                        }
                        return null;
                    }

                    private EPackage getNonEmptySuperPackage(EPackage ePackage) {
                        EPackage result = ePackage.getESuperPackage();
                        while (result != null && result.getEClassifiers().isEmpty()) {
                            result = result.getESuperPackage();
                        }
                        return result;
                    }

                    private URI redirect(URI uri) {
                        if (uri != null && !uri.isCurrentDocumentReference() && uri.hasFragment()) {
                            String relativePath;
                            EPackage ePackage;
                            EObject object;
                            URI base = uri.trimFragment();
                            String fragment = uri.fragment();
                            Resource resource = originalSet.getResource(base, false);
                            if (resource != null && (object = resource.getEObject(fragment)) != null && (ePackage = this.getContainingPackage(object)) != null && (relativePath = this.getRelativeFragmentPath(resource, (EObject)ePackage, fragment)) != null) {
                                StringBuilder path = new StringBuilder();
                                EPackage superPackage = this.getNonEmptySuperPackage(ePackage);
                                while (superPackage != null) {
                                    path.insert(0, '/');
                                    path.insert(1, ePackage.getName());
                                    ePackage = superPackage;
                                    superPackage = this.getNonEmptySuperPackage(ePackage);
                                }
                                path.insert(0, '/');
                                path.append(relativePath);
                                return URI.createURI((String)ePackage.getNsURI()).appendFragment(path.toString());
                            }
                        }
                        return uri;
                    }

                    public URI deresolve(URI uri) {
                        return super.deresolve(this.redirect(uri));
                    }

                    public URI resolve(URI uri) {
                        return super.resolve(this.redirect(uri));
                    }

                    public void setBaseURI(URI uri) {
                        super.setBaseURI(this.redirect(uri));
                    }
                };
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("URI_HANDLER", uriHandler);
                options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                options.put("LINE_DELIMITER", "");
                try {
                    outputResource.save(options);
                }
                catch (IOException exception) {
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
            finally {
                monitor.done();
            }
        } else {
            monitor.worked(1);
        }
    }

    protected int collapseEmptyPackages(EPackage ePackage) {
        EList subpackages = ePackage.getESubpackages();
        int i = 0;
        while (i < subpackages.size()) {
            EPackage subpackage = (EPackage)subpackages.get(i);
            i += this.collapseEmptyPackages(subpackage);
            subpackages = ePackage.getESubpackages();
            ++i;
        }
        EPackage superPackage = ePackage.getESuperPackage();
        if (superPackage != null && ePackage.getEClassifiers().isEmpty()) {
            int result = subpackages.size() - 1;
            EList siblingPackages = superPackage.getESubpackages();
            int i2 = siblingPackages.indexOf((Object)ePackage);
            siblingPackages.remove(i2);
            siblingPackages.addAll(i2, (Collection)subpackages);
            return result;
        }
        return 0;
    }

    protected void generatePackageInterface(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers() && !genModel.isSuppressEMFMetaData() && !genModel.isSuppressInterfaces()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaInterface_message", new Object[]{genPackage.getQualifiedPackageInterfaceName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionPackageName(), genPackage.getPackageInterfaceName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 0), new Object[]{new Object[]{genPackage, Boolean.TRUE, Boolean.FALSE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generatePackageClass(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedPackageClassName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionClassPackageName(), genPackage.getPackageClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 0), new Object[]{new Object[]{genPackage, genModel.isSuppressEMFMetaData() || genModel.isSuppressInterfaces() ? Boolean.TRUE : Boolean.FALSE, Boolean.TRUE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateFactoryInterface(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers() && !genModel.isSuppressInterfaces()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaInterface_message", new Object[]{genPackage.getQualifiedFactoryInterfaceName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionPackageName(), genPackage.getFactoryInterfaceName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 1), new Object[]{new Object[]{genPackage, Boolean.TRUE, Boolean.FALSE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateFactoryClass(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionClassPackageName(), genPackage.getFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 1), new Object[]{new Object[]{genPackage, genModel.isSuppressInterfaces() ? Boolean.TRUE : Boolean.FALSE, Boolean.TRUE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateXMLProcessorClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.getResource().getValue() == 3) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedXMLProcessorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getXMLProcessorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 2), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateValidatorClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.hasConstraints()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedValidatorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getValidatorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 3), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateSwitchClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isAdapterFactory() && !genPackage.getGenClasses().isEmpty()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedSwitchClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getSwitchClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 4), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateAdapterFactoryClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isAdapterFactory() && !genPackage.getGenClasses().isEmpty()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedAdapterFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getAdapterFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 5), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateResourceFactoryClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.getResource() != GenResourceKind.NONE_LITERAL) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedResourceFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getResourceFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 6), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateResourceClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.getResource() != GenResourceKind.NONE_LITERAL) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedResourceClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getResourceClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 7), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    @Override
    protected Diagnostic generateEdit(Object object, Monitor monitor) {
        GenPackage genPackage = (GenPackage)object;
        monitor.beginTask("", 2 + this.countCreateChildIcons(genPackage));
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingItemProvidersForPackage_message", new Object[]{genPackage.getBasicPackageName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getEditDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateItemProviderAdapterFactory(genPackage, monitor);
        this.generateCreateChildIcons(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateItemProviderAdapterFactory(GenPackage genPackage, Monitor monitor) {
        if (!genPackage.getGenClasses().isEmpty()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedItemProviderAdapterFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditDirectory(), genPackage.getProviderPackageName(), genPackage.getItemProviderAdapterFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 8), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected int countCreateChildIcons(GenPackage genPackage) {
        int result = 0;
        GenModel genModel = genPackage.getGenModel();
        if (genModel.isCreationCommands() && genModel.isCreationIcons() && genPackage.isChildCreationExtenders()) {
            for (Map.Entry<GenPackage, Map<GenClass, List<GenClass.ChildCreationData>>> packageEntry : genPackage.getExtendedChildCreationData().entrySet()) {
                for (Map.Entry<GenClass, List<GenClass.ChildCreationData>> classEntry : packageEntry.getValue().entrySet()) {
                    for (GenClass.ChildCreationData childCreationData : classEntry.getValue()) {
                        if (!(childCreationData.createClassifier instanceof GenClass) || childCreationData.delegatedFeature != null && !classEntry.getKey().getAllGenFeatures().contains(childCreationData.delegatedFeature)) continue;
                        ++result;
                    }
                }
            }
        }
        return result;
    }

    protected void generateCreateChildIcons(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genModel.isCreationCommands() && genModel.isCreationIcons() && genPackage.isChildCreationExtenders()) {
            for (Map.Entry<GenPackage, Map<GenClass, List<GenClass.ChildCreationData>>> packageEntry : genPackage.getExtendedChildCreationData().entrySet()) {
                for (Map.Entry<GenClass, List<GenClass.ChildCreationData>> classEntry : packageEntry.getValue().entrySet()) {
                    GenClass genClass = classEntry.getKey();
                    for (GenClass.ChildCreationData childCreationData : classEntry.getValue()) {
                        if (!(childCreationData.createClassifier instanceof GenClass) || childCreationData.delegatedFeature != null && !classEntry.getKey().getAllGenFeatures().contains(childCreationData.delegatedFeature)) continue;
                        GenClass childClass = (GenClass)childCreationData.createClassifier;
                        GenFeature feature = childCreationData.createFeature;
                        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingCreateChildIcon_message", new Object[]{classEntry.getKey().getCreateChildIconFileName(feature, childClass)});
                        monitor.subTask(this.message);
                        this.generateGIF(genClass.getCreateChildIconFileName(genModel, feature, childClass), this.getGIFEmitter(this.getInputPathNames(), 2), genClass.getName(), childClass.getName(), false, this.createMonitor(monitor, 1));
                    }
                }
            }
        }
    }

    @Override
    protected Diagnostic generateEditor(Object object, Monitor monitor) {
        monitor.beginTask("", 6);
        GenPackage genPackage = (GenPackage)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingEditorForPackage_message", new Object[]{genPackage.getBasicPackageName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getEditorDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateEditor(genPackage, monitor);
        this.generateModelWizard(genPackage, monitor);
        this.generateActionBarContributor(genPackage, monitor);
        this.generateModelIcon(genPackage, monitor);
        this.generateModelWizardIcon(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateEditor(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses() && genPackage.getGenModel().getRuntimePlatform() != GenRuntimePlatform.GWT) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedEditorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), genPackage.getEditorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 9), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateModelWizard(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses() && genPackage.isGenerateModelWizard() && genPackage.getGenModel().getRuntimePlatform() != GenRuntimePlatform.GWT) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedModelWizardClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), genPackage.getModelWizardClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 10), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateActionBarContributor(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses() && genPackage.getGenModel().getRuntimePlatform() != GenRuntimePlatform.GWT) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedActionBarContributorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), genPackage.getActionBarContributorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 11), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateModelIcon(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingModelIcon_message", new Object[]{genPackage.getModelIconFileName()});
            monitor.subTask(this.message);
            this.generateGIF(genPackage.getModelIconFileName(), this.getGIFEmitter(this.getInputPathNames(), 0), genPackage.getPrefix(), null, false, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateModelWizardIcon(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses() && genPackage.isGenerateModelWizard()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingModelWizardIcon_message", new Object[]{genPackage.getModelWizardIconFileName()});
            monitor.subTask(this.message);
            this.generateGIF(genPackage.getModelWizardIconFileName(), this.getGIFEmitter(this.getInputPathNames(), 1), genPackage.getPrefix(), null, false, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    @Override
    protected Diagnostic generateTests(Object object, Monitor monitor) {
        monitor.beginTask("", 3);
        GenPackage genPackage = (GenPackage)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingTestsForPackage_message", new Object[]{genPackage.getBasicPackageName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getTestsDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generatePackageTestSuite(genPackage, monitor);
        this.generatePackageExample(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generatePackageTestSuite(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedTestSuiteClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getTestsDirectory(), genPackage.getTestsPackageName(), genPackage.getTestSuiteClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 12), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generatePackageExample(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isGenerateExampleClass()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedExampleClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getTestsDirectory(), genPackage.getTestsPackageName(), genPackage.getExampleClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 13), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }
}

