/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.LocalRemoteFile;
import org.eclipse.osgi.util.NLS;

public class LocalFileSystemBrowser
extends AbstractFileSystemBrowser {
    protected File local;

    public LocalFileSystemBrowser(IFileID directoryID2, IRemoteFileSystemListener listener) throws RemoteFileSystemException {
        super(directoryID2, listener, null, null, null);
        try {
            this.local = new File(directoryID2.getURL().getPath());
        }
        catch (MalformedURLException e) {
            throw new RemoteFileSystemException((Throwable)e);
        }
        if (!this.local.exists()) {
            throw new RemoteFileSystemException(NLS.bind((String)Messages.FileSystemBrowser_EXCEPTION_DIRECTORY_DOES_NOT_EXIST, (Object)this.local));
        }
    }

    protected void runRequest() throws Exception {
        if (this.local.isDirectory()) {
            File[] files = this.local.listFiles();
            this.remoteFiles = new LocalRemoteFile[files.length];
            int i = 0;
            while (i < files.length) {
                this.remoteFiles[i] = new LocalRemoteFile(files[i]);
                ++i;
            }
        } else {
            this.remoteFiles = new LocalRemoteFile[1];
            this.remoteFiles[0] = new LocalRemoteFile(this.local);
        }
    }

    protected void setupProxy(Proxy proxy) {
    }
}

