/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.ConstantOperators;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

public class AbstractConstantExpressionsInterpreter {
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private ConstantOperators constantOperators;
    @Inject
    private OperatorMapping operatorMapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluate(XExpression expression, Context ctx) {
        Object _xtrycatchfinallyexpression;
        Object _xifexpression = null;
        boolean _add = ctx.getAlreadyEvaluating().add(expression);
        if (_add) {
            _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = this.internalEvaluate(expression, ctx);
            }
            finally {
                ctx.getAlreadyEvaluating().remove(expression);
            }
        } else {
            throw this.notConstantExpression(expression);
        }
        _xifexpression = _xtrycatchfinallyexpression;
        return _xifexpression;
    }

    protected Object _internalEvaluate(XExpression expression, Context ctx) {
        throw this.notConstantExpression(expression);
    }

    protected Object _internalEvaluate(Void nullValue, Context ctx) {
        throw this.notConstantExpression(null);
    }

    public ConstantExpressionEvaluationException notConstantExpression(XExpression expression) {
        String _text = null;
        if (expression != null) {
            _text = this.toText(expression);
        }
        String _plus = "Not a constant expression : '" + _text;
        String _plus_1 = _plus + "'";
        return new ConstantExpressionEvaluationException(_plus_1, expression);
    }

    protected Object _internalEvaluate(XCastedExpression expression, Context ctx) {
        return this.evaluate(expression.getTarget(), ctx);
    }

    protected Object _internalEvaluate(XStringLiteral it, Context ctx) {
        return it.getValue();
    }

    protected Object _internalEvaluate(XBooleanLiteral it, Context ctx) {
        return it.isIsTrue();
    }

    protected Object _internalEvaluate(XAnnotation literal, Context ctx) {
        return literal;
    }

    protected Object _internalEvaluate(XTypeLiteral it, Context ctx) {
        return this.toTypeReference(it.getType(), it.getArrayDimensions().size());
    }

    protected JvmTypeReference toTypeReference(JvmType type, int arrayDimensions) {
        if (type == null) {
            return null;
        }
        JvmParameterizedTypeReference _createJvmParameterizedTypeReference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        Procedures.Procedure1 _function = it -> it.setType(type);
        JvmTypeReference resultTypeRef = (JvmTypeReference)ObjectExtensions.operator_doubleArrow((Object)_createJvmParameterizedTypeReference, (Procedures.Procedure1)_function);
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, arrayDimensions, true);
        for (Integer i : _doubleDotLessThan) {
            JvmGenericArrayTypeReference arrayRef = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
            arrayRef.setComponentType(resultTypeRef);
            resultTypeRef = arrayRef;
        }
        return resultTypeRef;
    }

    protected Object _internalEvaluate(XBinaryOperation it, Context ctx) {
        Object _xblockexpression = null;
        Context context = ctx.cloneWithExpectation(null);
        Object left = this.evaluate(it.getLeftOperand(), context);
        Object right = this.evaluate(it.getRightOperand(), context);
        _xblockexpression = this.evaluateBinaryOperation(it, left, right);
        return _xblockexpression;
    }

    protected Object evaluateBinaryOperation(XBinaryOperation binaryOperation, Object left, Object right) {
        Object _xblockexpression = null;
        String op = this.getOperator(binaryOperation);
        Object _switchResult = null;
        if (op != null) {
            switch (op) {
                case "+": {
                    _switchResult = this.constantOperators.plus(left, right);
                    break;
                }
                case "-": {
                    _switchResult = this.constantOperators.minus(left, right);
                    break;
                }
                case "*": {
                    _switchResult = this.constantOperators.multiply(left, right);
                    break;
                }
                case "/": {
                    _switchResult = this.constantOperators.divide(left, right);
                    break;
                }
                case "%": {
                    _switchResult = this.constantOperators.modulo(left, right);
                    break;
                }
                case "&&": {
                    _switchResult = this.constantOperators.and(left, right);
                    break;
                }
                case "||": {
                    _switchResult = this.constantOperators.or(left, right);
                    break;
                }
                case "<<": {
                    _switchResult = this.constantOperators.shiftLeft(left, right);
                    break;
                }
                case ">>": {
                    _switchResult = this.constantOperators.shiftRight(left, right);
                    break;
                }
                case ">>>": {
                    _switchResult = this.constantOperators.shiftRightUnsigned(left, right);
                    break;
                }
                case "<": {
                    _switchResult = this.constantOperators.lessThan(left, right);
                    break;
                }
                case ">": {
                    _switchResult = this.constantOperators.greaterThan(left, right);
                    break;
                }
                case "<=": {
                    _switchResult = this.constantOperators.lessEquals(left, right);
                    break;
                }
                case ">=": {
                    _switchResult = this.constantOperators.greaterEquals(left, right);
                    break;
                }
                case "==": 
                case "===": {
                    _switchResult = this.constantOperators.same(left, right);
                    break;
                }
                case "!=": 
                case "!==": {
                    _switchResult = this.constantOperators.notSame(left, right);
                    break;
                }
                default: {
                    throw new ConstantExpressionEvaluationException("Couldn't evaluate binary operator '" + op + "' on values " + left + " and " + right);
                }
            }
        } else {
            throw new ConstantExpressionEvaluationException("Couldn't evaluate binary operator '" + op + "' on values " + left + " and " + right);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected Object _internalEvaluate(XUnaryOperation it, Context ctx) {
        Object _xblockexpression = null;
        Object value = this.evaluate(it.getOperand(), ctx);
        String op = this.getOperator(it);
        Object _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)op, (Object)"-")) {
            _matched = true;
            _switchResult = this.constantOperators.minus(value);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"!") && value instanceof Boolean) {
            _matched = true;
            _switchResult = (Boolean)value == false;
        }
        if (!_matched && Objects.equal((Object)op, (Object)"+") && value instanceof Number) {
            _matched = true;
            _switchResult = value;
        }
        if (!_matched) {
            throw new ConstantExpressionEvaluationException("Couldn't evaluate unary operator '" + op + "' on value " + value);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String getOperator(XAbstractFeatureCall call) {
        boolean _isLoadedFromStorage;
        Resource _eResource;
        String _switchResult = null;
        Resource res = _eResource = call.eResource();
        boolean _matched = false;
        if (res instanceof StorageAwareResource && (_isLoadedFromStorage = ((StorageAwareResource)res).isLoadedFromStorage())) {
            _matched = true;
            QualifiedName _operator = this.operatorMapping.getOperator(QualifiedName.create((String)call.getFeature().getSimpleName()));
            String _string = null;
            if (_operator != null) {
                _string = _operator.toString();
            }
            return _string;
        }
        if (!_matched) {
            _switchResult = call.getConcreteSyntaxFeatureName();
        }
        return _switchResult;
    }

    protected String toText(XExpression expression) {
        return NodeModelUtils.getNode((EObject)expression).getText();
    }

    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        if (it == null) {
            return this._internalEvaluate((Void)null, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, ctx).toString());
    }

    @Pure
    protected ConstantOperators getConstantOperators() {
        return this.constantOperators;
    }
}

