/*******************************************************************************
 * Copyright (c) 2000, 2013 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
							TokenNameWHITESPACE = 1000,
							TokenNameCOMMENT_LINE = 1001,
							TokenNameCOMMENT_BLOCK = 1002,
							TokenNameCOMMENT_JAVADOC = 1003;

	int TokenNameIdentifier = 22,
							TokenNameabstract = 51,
							TokenNameassert = 73,
							TokenNameboolean = 97,
							TokenNamebreak = 74,
							TokenNamebyte = 98,
							TokenNamecase = 99,
							TokenNamecatch = 100,
							TokenNamechar = 101,
							TokenNameclass = 66,
							TokenNamecontinue = 75,
							TokenNameconst = 126,
							TokenNamedefault = 71,
							TokenNamedo = 76,
							TokenNamedouble = 102,
							TokenNameelse = 111,
							TokenNameenum = 69,
							TokenNameextends = 85,
							TokenNamefalse = 39,
							TokenNamefinal = 52,
							TokenNamefinally = 109,
							TokenNamefloat = 103,
							TokenNamefor = 77,
							TokenNamegoto = 127,
							TokenNameif = 78,
							TokenNameimplements = 122,
							TokenNameimport = 104,
							TokenNameinstanceof = 17,
							TokenNameint = 105,
							TokenNameinterface = 68,
							TokenNamelong = 106,
							TokenNamenative = 53,
							TokenNamenew = 36,
							TokenNamenull = 40,
							TokenNamepackage = 84,
							TokenNameprivate = 54,
							TokenNameprotected = 55,
							TokenNamepublic = 56,
							TokenNamereturn = 79,
							TokenNameshort = 107,
							TokenNamestatic = 38,
							TokenNamestrictfp = 57,
							TokenNamesuper = 34,
							TokenNameswitch = 80,
							TokenNamesynchronized = 50,
							TokenNamethis = 35,
							TokenNamethrow = 81,
							TokenNamethrows = 119,
							TokenNametransient = 58,
							TokenNametrue = 41,
							TokenNametry = 82,
							TokenNamevoid = 108,
							TokenNamevolatile = 59,
							TokenNamewhile = 72,
							TokenNamemodule = 112,
							TokenNameopen = 113,
							TokenNamerequires = 114,
							TokenNametransitive = 120,
							TokenNameexports = 115,
							TokenNameopens = 116,
							TokenNameto = 123,
							TokenNameuses = 117,
							TokenNameprovides = 118,
							TokenNamewith = 124,
							TokenNameIntegerLiteral = 42,
							TokenNameLongLiteral = 43,
							TokenNameFloatingPointLiteral = 44,
							TokenNameDoubleLiteral = 45,
							TokenNameCharacterLiteral = 46,
							TokenNameStringLiteral = 47,
							TokenNamePLUS_PLUS = 2,
							TokenNameMINUS_MINUS = 3,
							TokenNameEQUAL_EQUAL = 19,
							TokenNameLESS_EQUAL = 12,
							TokenNameGREATER_EQUAL = 13,
							TokenNameNOT_EQUAL = 20,
							TokenNameLEFT_SHIFT = 18,
							TokenNameRIGHT_SHIFT = 14,
							TokenNameUNSIGNED_RIGHT_SHIFT = 16,
							TokenNamePLUS_EQUAL = 86,
							TokenNameMINUS_EQUAL = 87,
							TokenNameMULTIPLY_EQUAL = 88,
							TokenNameDIVIDE_EQUAL = 89,
							TokenNameAND_EQUAL = 90,
							TokenNameOR_EQUAL = 91,
							TokenNameXOR_EQUAL = 92,
							TokenNameREMAINDER_EQUAL = 93,
							TokenNameLEFT_SHIFT_EQUAL = 94,
							TokenNameRIGHT_SHIFT_EQUAL = 95,
							TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 96,
							TokenNameOR_OR = 31,
							TokenNameAND_AND = 30,
							TokenNamePLUS = 4,
							TokenNameMINUS = 5,
							TokenNameNOT = 62,
							TokenNameREMAINDER = 9,
							TokenNameXOR = 23,
							TokenNameAND = 21,
							TokenNameMULTIPLY = 8,
							TokenNameOR = 27,
							TokenNameTWIDDLE = 63,
							TokenNameDIVIDE = 10,
							TokenNameGREATER = 15,
							TokenNameLESS = 11,
							TokenNameLPAREN = 24,
							TokenNameRPAREN = 25,
							TokenNameLBRACE = 48,
							TokenNameRBRACE = 33,
							TokenNameLBRACKET = 6,
							TokenNameRBRACKET = 64,
							TokenNameSEMICOLON = 26,
							TokenNameQUESTION = 29,
							TokenNameCOLON = 61,
							TokenNameCOMMA = 32,
							TokenNameDOT = 1,
							TokenNameEQUAL = 70,
							TokenNameAT = 37,
							TokenNameELLIPSIS = 121,
							TokenNameARROW = 110,
							TokenNameCOLON_COLON = 7,
							TokenNameBeginLambda = 49,
							TokenNameBeginIntersectionCast = 65,
							TokenNameBeginTypeArguments = 83,
							TokenNameElidedSemicolonAndRightBrace = 67,
							TokenNameAT308 = 28,
							TokenNameAT308DOTDOTDOT = 125,
							TokenNameEOF = 60,
							TokenNameERROR = 128;
}
