/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import javafx.scene.Node;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.controls.stage.FrameEvent;
import org.eclipse.fx.ui.services.dialog.LightWeightDialogService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDialogHost;

public class FXDialogService
implements LightWeightDialogService {
    private final IEclipseContext context;
    @Log
    @Inject
    private Logger logger;

    @Inject
    public FXDialogService(IEclipseContext context) {
        this.context = context;
    }

    public <T extends Node> T openDialog(Class<T> dialogClass, LightWeightDialogService.ModalityScope scope) {
        WDialogHost host = null;
        if (scope == LightWeightDialogService.ModalityScope.WINDOW) {
            MWindow window = (MWindow)this.context.get(MWindow.class);
            host = (WDialogHost)window.getWidget();
        } else if (scope == LightWeightDialogService.ModalityScope.PERSPECTIVE) {
            MPerspective perspective = (MPerspective)this.context.get(MPerspective.class);
            if (perspective == null) {
                return this.openDialog(dialogClass, LightWeightDialogService.ModalityScope.WINDOW);
            }
            host = (WDialogHost)perspective.getWidget();
        } else if (scope == LightWeightDialogService.ModalityScope.PART) {
            MPart part = (MPart)this.context.get(MPart.class);
            if (part == null) {
                return this.openDialog(dialogClass, LightWeightDialogService.ModalityScope.PERSPECTIVE);
            }
            host = (WDialogHost)part.getWidget();
        }
        if (host != null) {
            WDialogHost fhost = host;
            IEclipseContext dialogContext = this.context.createChild();
            Node dialogInstance = (Node)ContextInjectionFactory.make(dialogClass, (IEclipseContext)dialogContext);
            if (dialogInstance == null) {
                throw new IllegalStateException("The new instance must not be null");
            }
            dialogInstance.addEventHandler(FrameEvent.CLOSED, e -> fhost.setDialog(null));
            fhost.setDialog((Object)dialogInstance);
            return (T)dialogInstance;
        }
        this.logger.error("Could not find a host for '" + dialogClass + "'");
        throw new IllegalStateException();
    }

    public <T extends Node> void openDialog(T dialog, LightWeightDialogService.ModalityScope scope) {
        T dialogInstance;
        WDialogHost fhost;
        WDialogHost host = null;
        if (scope == LightWeightDialogService.ModalityScope.WINDOW) {
            MWindow window = (MWindow)this.context.get(MWindow.class);
            host = (WDialogHost)window.getWidget();
        } else if (scope == LightWeightDialogService.ModalityScope.PERSPECTIVE) {
            MPerspective perspective = (MPerspective)this.context.get(MPerspective.class);
            if (perspective == null) {
                this.openDialog(dialog, LightWeightDialogService.ModalityScope.WINDOW);
            } else {
                host = (WDialogHost)perspective.getWidget();
            }
        } else if (scope == LightWeightDialogService.ModalityScope.PART) {
            MPart part = (MPart)this.context.get(MPart.class);
            if (part == null) {
                this.openDialog(dialog, LightWeightDialogService.ModalityScope.PERSPECTIVE);
            } else {
                host = (WDialogHost)part.getWidget();
            }
        }
        if (host != null) {
            fhost = host;
            IEclipseContext dialogContext = this.context.createChild();
            dialogInstance = dialog;
            if (dialogInstance == null) {
                throw new IllegalStateException("The new instance must not be null");
            }
        } else {
            throw new IllegalStateException();
        }
        dialogInstance.addEventHandler(FrameEvent.CLOSED, e -> fhost.setDialog(null));
        fhost.setDialog(dialogInstance);
    }
}

