/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompositeOperator implements Enumerator
{
    OVER(0, "over", "over"),
    IN(1, "in", "in"),
    OUT(2, "out", "out"),
    ATOP(3, "atop", "atop"),
    XOR(4, "xor", "xor"),
    ARITHMETIC(5, "arithmetic", "arithmetic");

    public static final int OVER_VALUE = 0;
    public static final int IN_VALUE = 1;
    public static final int OUT_VALUE = 2;
    public static final int ATOP_VALUE = 3;
    public static final int XOR_VALUE = 4;
    public static final int ARITHMETIC_VALUE = 5;
    private static final CompositeOperator[] VALUES_ARRAY;
    public static final List<CompositeOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompositeOperator[]{OVER, IN, OUT, ATOP, XOR, ARITHMETIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompositeOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompositeOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompositeOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompositeOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompositeOperator get(int value) {
        switch (value) {
            case 0: {
                return OVER;
            }
            case 1: {
                return IN;
            }
            case 2: {
                return OUT;
            }
            case 3: {
                return ATOP;
            }
            case 4: {
                return XOR;
            }
            case 5: {
                return ARITHMETIC;
            }
        }
        return null;
    }

    private CompositeOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

