/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAssigner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class CompoundTypeAssigner
implements ITypeAssigner {
    private final TypeAssigner[] assigners;
    private final ITypeReferenceOwner owner;

    public CompoundTypeAssigner(ITypeReferenceOwner owner, TypeAssigner[] assigners) {
        this.owner = owner;
        this.assigners = assigners;
    }

    @Override
    public void assignType(JvmIdentifiableElement element, LightweightTypeReference actualType) {
        for (TypeAssigner assigner : this.assigners) {
            assigner.assignType(element, actualType);
        }
    }

    @Override
    public ITypeComputationState getForkedState() {
        AbstractTypeComputationState[] states = new AbstractTypeComputationState[this.assigners.length];
        for (int i = 0; i < states.length; ++i) {
            states[i] = this.assigners[i].getForkedState();
        }
        return new CompoundTypeComputationState(this.owner, states);
    }

    @Override
    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference reference) {
        return this.owner.toLightweightTypeReference(reference);
    }

    @Override
    public ITypeReferenceOwner getReferenceOwner() {
        return this.owner;
    }
}

