/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import java.util.List;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.events.HoverTarget;
import org.eclipse.fx.ui.controls.styledtext.events.TextHoverEvent;
import org.eclipse.fx.ui.controls.styledtext.internal.ContentView;

public class HoverSupport {
    private static boolean DEBUG_HOVER = Boolean.getBoolean("org.eclipse.fx.ui.controls.styledtext.debug");
    private Region control;
    private TextHoverEvent lastHover;
    private TextHoverEvent curHover;
    private long curHoverTimeout;

    public HoverSupport(Region control) {
        this.control = control;
    }

    protected void install() {
        this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        this.control.addEventHandler(MouseEvent.MOUSE_MOVED, this::onMouseMoved);
        this.control.addEventHandler(MouseEvent.MOUSE_EXITED, this::onMouseExited);
        Util.installHoverCallback((Node)this.control, Duration.millis((double)300.0), this::handleHover);
    }

    private void fireHoverEvent(MouseEvent event, List<HoverTarget> hoverTargets) {
        if (hoverTargets == null) {
            if (DEBUG_HOVER) {
                System.err.println("fireHoverEvent " + hoverTargets);
            }
            Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, -1, -1, -1, ""));
        } else {
            if (DEBUG_HOVER) {
                System.err.println("fireHoverEvent " + hoverTargets);
            }
            Event.fireEvent((EventTarget)this.control, (Event)new TextHoverEvent(event, hoverTargets));
        }
    }

    public static HoverSupport install(Region control) {
        HoverSupport support = new HoverSupport(control);
        support.install();
        return support;
    }

    private void onMouseExited(MouseEvent event) {
        if (DEBUG_HOVER) {
            System.err.println("HoverManager: onMouseExited");
        }
        if (!this.control.getBoundsInLocal().contains(event.getX(), event.getY())) {
            this.fireHoverEvent(event, null);
        }
    }

    private void onMouseMoved(MouseEvent event) {
    }

    private void onMousePressed(MouseEvent event) {
        if (DEBUG_HOVER) {
            System.err.println("HoverManager: onMousePressed");
        }
        this.fireHoverEvent(event, null);
    }

    protected static TextHoverEvent createHoverEvent(MouseEvent e) {
        return new TextHoverEvent(e, -1, -1, -1, "");
    }

    protected void handleHover(MouseEvent event) {
        if (DEBUG_HOVER) {
            System.err.println("HoverManager: handleHover");
        }
        List<HoverTarget> hoverTargets = ((ContentView)this.control).findHoverTargets(new Point2D(event.getX(), event.getY()));
        this.fireHoverEvent(event, hoverTargets);
    }
}

